/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.rsm.ResultSetManager;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSet;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;

public final class ServiceDiscoveryManager
extends ExtensionManager {
    private static Identity defaultIdentity = new Identity("client", "pc");
    private final Set<Identity> identities = new ConcurrentSkipListSet<Identity>();
    private final Set<Feature> features = new ConcurrentSkipListSet<Feature>();
    private final List<DataForm> extensions = new CopyOnWriteArrayList<DataForm>();
    private final Map<String, InfoNode> infoNodeMap = new ConcurrentHashMap<String, InfoNode>();
    private final Map<String, ResultSetProvider<Item>> itemProviders = new ConcurrentHashMap<String, ResultSetProvider<Item>>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private ServiceDiscoveryManager(XmppSession xmppSession) {
        super(xmppSession, "http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items");
        this.setEnabled(true);
    }

    @Override
    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            @Override
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    for (PropertyChangeListener propertyChangeListener : ServiceDiscoveryManager.this.pcs.getPropertyChangeListeners()) {
                        ServiceDiscoveryManager.this.pcs.removePropertyChangeListener(propertyChangeListener);
                    }
                }
                ServiceDiscoveryManager.this.infoNodeMap.clear();
                ServiceDiscoveryManager.this.itemProviders.clear();
            }
        });
        this.xmppSession.addIQHandler(InfoDiscovery.class, new AbstractIQHandler(this, AbstractIQ.Type.GET){

            @Override
            protected IQ processRequest(IQ iq) {
                InfoDiscovery infoDiscovery = (InfoDiscovery)iq.getExtension(InfoDiscovery.class);
                if (infoDiscovery.getNode() == null) {
                    return iq.createResult((Object)new InfoDiscovery(ServiceDiscoveryManager.this.getIdentities(), ServiceDiscoveryManager.this.getFeatures(), ServiceDiscoveryManager.this.getExtensions()));
                }
                InfoNode infoNode = (InfoNode)ServiceDiscoveryManager.this.infoNodeMap.get(infoDiscovery.getNode());
                if (infoNode != null) {
                    return iq.createResult((Object)new InfoDiscovery(infoNode.getNode(), (Collection)infoNode.getIdentities(), (Collection)infoNode.getFeatures(), (Collection)infoNode.getExtensions()));
                }
                return iq.createError(Condition.FEATURE_NOT_IMPLEMENTED);
            }
        });
        this.xmppSession.addIQHandler(ItemDiscovery.class, new AbstractIQHandler(this, AbstractIQ.Type.GET){

            @Override
            protected IQ processRequest(IQ iq) {
                ItemDiscovery itemDiscovery = (ItemDiscovery)iq.getExtension(ItemDiscovery.class);
                ResultSetProvider itemProvider = (ResultSetProvider)ServiceDiscoveryManager.this.itemProviders.get(itemDiscovery.getNode() == null ? "" : itemDiscovery.getNode());
                if (itemProvider != null) {
                    ResultSet resultSet = ResultSetManager.createResultSet(itemProvider, itemDiscovery.getResultSetManagement());
                    return iq.createResult((Object)new ItemDiscovery(itemDiscovery.getNode(), (Collection)resultSet.getItems(), resultSet.getResultSetManagement()));
                }
                if (itemDiscovery.getNode() == null) {
                    return iq.createResult((Object)new ItemDiscovery(itemDiscovery.getNode()));
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public List<Item> getItems() {
        ResultSetProvider<Item> rootItemProvider = this.itemProviders.get("");
        if (rootItemProvider != null) {
            return Collections.unmodifiableList(rootItemProvider.getItems());
        }
        return Collections.emptyList();
    }

    public synchronized Set<Identity> getIdentities() {
        HashSet<Identity> ids;
        if (!this.identities.isEmpty()) {
            ids = new HashSet<Identity>(this.identities);
        } else {
            ids = new HashSet<Identity>();
            ids.add(defaultIdentity);
        }
        return Collections.unmodifiableSet(ids);
    }

    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(new HashSet<Feature>(this.features));
    }

    public List<DataForm> getExtensions() {
        return Collections.unmodifiableList(new ArrayList<DataForm>(this.extensions));
    }

    public synchronized void addIdentity(Identity identity) {
        Set<Identity> oldList = this.getIdentities();
        this.identities.add(identity);
        this.pcs.firePropertyChange("identities", oldList, this.getIdentities());
    }

    public synchronized void removeIdentity(Identity identity) {
        Set<Identity> oldList = this.getIdentities();
        this.identities.remove(identity);
        this.pcs.firePropertyChange("identities", oldList, this.getIdentities());
    }

    public synchronized void addFeature(Feature feature) {
        Set<Feature> oldList = this.getFeatures();
        this.features.add(feature);
        this.pcs.firePropertyChange("features", oldList, this.getFeatures());
    }

    public synchronized void removeFeature(Feature feature) {
        Set<Feature> oldList = this.getFeatures();
        this.features.remove(feature);
        this.pcs.firePropertyChange("features", oldList, this.getFeatures());
    }

    public synchronized void addExtension(DataForm extension) {
        List<DataForm> oldList = this.getExtensions();
        this.extensions.add(extension);
        this.pcs.firePropertyChange("extensions", oldList, this.getExtensions());
    }

    public synchronized void removeExtension(DataForm extension) {
        List<DataForm> oldList = this.getExtensions();
        this.extensions.remove(extension);
        this.pcs.firePropertyChange("extensions", oldList, this.getExtensions());
    }

    public InfoNode discoverInformation(Jid jid) throws XmppException {
        return this.discoverInformation(jid, null);
    }

    public InfoNode discoverInformation(Jid jid, String node) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)new InfoDiscovery(node)));
        return (InfoNode)result.getExtension(InfoDiscovery.class);
    }

    public ItemNode discoverItems(Jid jid) throws XmppException {
        return this.discoverItems(jid, null, null);
    }

    public ItemNode discoverItems(Jid jid, ResultSetManagement resultSet) throws XmppException {
        return this.discoverItems(jid, null, resultSet);
    }

    public ItemNode discoverItems(Jid jid, String node) throws XmppException {
        return this.discoverItems(jid, node, null);
    }

    public ItemNode discoverItems(Jid jid, String node, ResultSetManagement resultSetManagement) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)new ItemDiscovery(node, resultSetManagement)));
        return (ItemNode)result.getExtension(ItemDiscovery.class);
    }

    public Collection<Item> discoverServices(String feature) throws XmppException {
        ItemNode itemDiscovery = this.discoverItems(Jid.valueOf((String)this.xmppSession.getDomain()));
        ArrayList<Item> services = new ArrayList<Item>();
        XmppException exception = null;
        for (Item item : itemDiscovery.getItems()) {
            try {
                InfoNode infoDiscovery = this.discoverInformation(item.getJid());
                if (!infoDiscovery.getFeatures().contains(new Feature(feature))) continue;
                services.add(item);
            }
            catch (XmppException e) {
                exception = e;
            }
        }
        if (exception != null && services.isEmpty()) {
            throw exception;
        }
        return services;
    }

    public void addInfoNode(InfoNode infoNode) {
        this.infoNodeMap.put(infoNode.getNode(), infoNode);
    }

    public void removeInfoNode(String node) {
        this.infoNodeMap.remove(node);
    }

    public void setItemProvider(ResultSetProvider<Item> itemProvider) {
        if (itemProvider == null) {
            this.itemProviders.remove("");
        } else {
            this.itemProviders.put("", itemProvider);
        }
    }

    public void setItemProvider(String node, ResultSetProvider<Item> itemProvider) {
        if (itemProvider == null) {
            this.itemProviders.remove(node);
        } else {
            this.itemProviders.put(node, itemProvider);
        }
    }
}

