/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.xml.bind.DatatypeConverter;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.sasl.scram.ScramClient;
import rocks.xmpp.core.sasl.scram.ScramServer;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppClient;
import rocks.xmpp.core.session.XmppSessionConfiguration;

public class ScramClientTest {
    @Test
    public void testHiFunction() throws InvalidKeyException, NoSuchAlgorithmException, SaslException {
        ScramClient scramSaslClient = new ScramClient("SHA-1", "server", callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName("Test");
                }
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword("pencil".toCharArray());
            }
        });
        scramSaslClient.evaluateChallenge(new byte[0]);
        Assert.assertEquals((String)DatatypeConverter.printBase64Binary((byte[])scramSaslClient.hi("test".getBytes(StandardCharsets.UTF_8), "salt".getBytes(StandardCharsets.UTF_8), 4096)), (String)"suIjHg0e14CDoom6wmHKz3naWOc=");
    }

    @Test
    public void testSasl() throws SaslException {
        List saslMechs = XmppSessionConfiguration.getDefault().getAuthenticationMechanisms();
        String[] preferredMechanisms = saslMechs.toArray(new String[saslMechs.size()]);
        SaslClient sc = Sasl.createSaslClient(preferredMechanisms, "authorizationId", "xmpp", "localhost", null, callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName("admin");
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword("admin".toCharArray());
                }
                if (!(callback instanceof RealmCallback)) continue;
                ((RealmCallback)callback).setText("realm");
            }
        });
        Assert.assertNotNull((Object)sc);
    }

    @Test
    public void testServerResponse() throws SaslException {
        ScramClient scramSha1SaslClient = new ScramClient("SHA-1", null, callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName("user");
                }
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword("pencil".toCharArray());
            }
        });
        String serverResponse = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096";
        scramSha1SaslClient.evaluateChallenge(new byte[0]);
        byte[] result = scramSha1SaslClient.evaluateChallenge(serverResponse.getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)new String(result).startsWith("c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p="));
    }

    @Test
    public void testReplacement() {
        String username = ",=,==";
        Assert.assertEquals((String)"=2C=3D=2C=3D=3D", (String)ScramClient.replaceUsername((String)username));
    }

    @Test
    public void testClientServer() throws SaslException, ClassNotFoundException {
        new XmppClient(null, new ConnectionConfiguration[0]);
        SaslClient saslClient = Sasl.createSaslClient(new String[]{"SCRAM-SHA-1"}, "authzid", "xmpp", "servername", null, callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName("Test");
                }
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword("==".toCharArray());
            }
        });
        byte[] initialResponse = saslClient.evaluateChallenge(new byte[0]);
        ScramServer scramServer = new ScramServer("SHA-1", callbacks -> {
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword("==".toCharArray());
            }
        });
        byte[] challenge = scramServer.evaluateResponse(initialResponse);
        byte[] response = saslClient.evaluateChallenge(challenge);
        byte[] serverFinalMessage = scramServer.evaluateResponse(response);
        Assert.assertTrue((boolean)new String(serverFinalMessage).startsWith("v="));
    }
}

