/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.IntegrationTest;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppClient;
import rocks.xmpp.core.session.XmppSession;

public class MultiThreadingIT
extends IntegrationTest {
    @Test
    public void shouldNotCloseMoreThanOnce() throws XmppException, InterruptedException {
        XmppClient xmppSession = new XmppClient("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        AtomicInteger closing = new AtomicInteger();
        AtomicInteger closed = new AtomicInteger();
        xmppSession.addSessionStatusListener(e -> {
            if (e.getStatus() == XmppSession.Status.CLOSING) {
                closing.incrementAndGet();
            }
            if (e.getStatus() == XmppSession.Status.CLOSED) {
                closed.incrementAndGet();
            }
        });
        xmppSession.connect();
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(100);
        AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(() -> {
                try {
                    xmppSession.close();
                }
                catch (XmppException e) {
                    exception.set(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)closing.get(), (int)1);
        Assert.assertEquals((int)closed.get(), (int)1);
        if (exception.get() != null) {
            Assert.fail((String)((Exception)exception.get()).getMessage(), (Throwable)((Throwable)exception.get()));
        }
    }

    @Test
    public void shouldNotConnectMoreThanOnceWhileConnected() throws Exception {
        XmppClient xmppSession = new XmppClient("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        AtomicInteger connecting = new AtomicInteger();
        AtomicInteger connected = new AtomicInteger();
        xmppSession.addSessionStatusListener(e -> {
            if (e.getStatus() == XmppSession.Status.CONNECTING) {
                connecting.incrementAndGet();
            }
            if (e.getStatus() == XmppSession.Status.CONNECTED) {
                connected.incrementAndGet();
            }
        });
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(100);
        AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(() -> {
                try {
                    xmppSession.connect();
                }
                catch (XmppException e) {
                    exception.set(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)connecting.get(), (int)1);
        Assert.assertEquals((int)connected.get(), (int)1);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    @Test
    public void shouldNotConnectWhileLoggedIn() throws Exception {
        XmppClient xmppSession = new XmppClient("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        AtomicInteger connecting = new AtomicInteger();
        AtomicInteger connected = new AtomicInteger();
        xmppSession.addSessionStatusListener(e -> {
            if (e.getStatus() == XmppSession.Status.CONNECTING) {
                connecting.incrementAndGet();
            }
            if (e.getStatus() == XmppSession.Status.CONNECTED) {
                connected.incrementAndGet();
            }
        });
        xmppSession.connect();
        xmppSession.loginAnonymously();
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(100);
        AtomicReference exception = new AtomicReference();
        for (int i = 0; i < 100; ++i) {
            executor.execute(() -> {
                try {
                    xmppSession.connect();
                }
                catch (XmppException e) {
                    exception.set(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)connecting.get(), (int)1);
        Assert.assertEquals((int)connected.get(), (int)1);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    @Test
    public void shouldOnlyLoginOnce() throws Exception {
        XmppClient xmppSession = new XmppClient("localhost", new ConnectionConfiguration[]{TcpConnectionConfiguration.getDefault()});
        AtomicInteger authenticating = new AtomicInteger();
        AtomicInteger authenticated = new AtomicInteger();
        AtomicInteger exceptions = new AtomicInteger();
        xmppSession.addSessionStatusListener(e -> {
            if (e.getStatus() == XmppSession.Status.AUTHENTICATING) {
                authenticating.incrementAndGet();
            }
            if (e.getStatus() == XmppSession.Status.AUTHENTICATED) {
                authenticated.incrementAndGet();
            }
        });
        xmppSession.connect();
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            executor.execute(() -> {
                try {
                    xmppSession.login("111", "111");
                }
                catch (Exception e) {
                    exceptions.incrementAndGet();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await();
        Assert.assertEquals((int)authenticating.get(), (int)1);
        Assert.assertEquals((int)authenticated.get(), (int)1);
        Assert.assertEquals((int)exceptions.get(), (int)99);
    }
}

