/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.BaseTest;
import rocks.xmpp.core.session.TestXmppSession;
import rocks.xmpp.im.roster.RosterManager;
import rocks.xmpp.im.roster.model.Contact;
import rocks.xmpp.im.roster.model.ContactGroup;
import rocks.xmpp.im.roster.model.Roster;

public class RosterManagerTest
extends BaseTest {
    @Test
    public void testRosterListener() throws XMLStreamException, JAXBException {
        int[] rosterPushCount = new int[1];
        TestXmppSession xmppSession1 = new TestXmppSession();
        RosterManager rosterManager = (RosterManager)xmppSession1.getManager(RosterManager.class);
        rosterManager.addRosterListener(e -> {
            if (rosterPushCount[0] == 0) {
                Assert.assertEquals((int)e.getAddedContacts().size(), (int)3);
                Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
            } else if (rosterPushCount[0] == 1) {
                Assert.assertEquals((int)e.getAddedContacts().size(), (int)1);
                Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
            } else if (rosterPushCount[0] == 2) {
                Assert.assertEquals((int)e.getAddedContacts().size(), (int)0);
                Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)0);
                Assert.assertEquals((int)e.getRemovedContacts().size(), (int)1);
                Assert.assertEquals((Object)((Contact)e.getRemovedContacts().get(0)).getJid(), (Object)Jid.of((String)"contact2@domain"));
            } else if (rosterPushCount[0] == 3) {
                Assert.assertEquals((int)e.getAddedContacts().size(), (int)0);
                Assert.assertEquals((int)e.getUpdatedContacts().size(), (int)1);
                Assert.assertEquals((int)e.getRemovedContacts().size(), (int)0);
                Assert.assertEquals((Object)((Contact)e.getUpdatedContacts().get(0)).getJid(), (Object)Jid.of((String)"contact1@domain"));
                Assert.assertEquals((String)((Contact)e.getUpdatedContacts().get(0)).getName(), (String)"Name");
            }
        });
        Roster roster1 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact1@domain")), new Contact(Jid.of((String)"contact2@domain")), new Contact(Jid.of((String)"contact3@domain"))});
        rosterManager.updateRoster(roster1, false);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster2 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact4@domain"))});
        rosterManager.updateRoster(roster2, true);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster3 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact2@domain"), null, Boolean.valueOf(false), null, Contact.Subscription.REMOVE, Collections.emptyList())});
        rosterManager.updateRoster(roster3, true);
        rosterPushCount[0] = rosterPushCount[0] + 1;
        Roster roster4 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact1@domain"), "Name")});
        rosterManager.updateRoster(roster4, true);
    }

    @Test
    public void testRosterGroups() {
        TestXmppSession xmppSession1 = new TestXmppSession();
        RosterManager rosterManager = (RosterManager)xmppSession1.getManager(RosterManager.class);
        Roster roster1 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact1@domain"), "contact1", new String[]{"Group1"}), new Contact(Jid.of((String)"contact2@domain"), "contact2", new String[]{"Group2"}), new Contact(Jid.of((String)"contact4@domain"), "contact4", new String[]{"Group3"}), new Contact(Jid.of((String)"contact3@domain"), "contact3", new String[]{"Group3"}), new Contact(Jid.of((String)"contact5@domain"), "contact5", new String[]{"Group3"})});
        rosterManager.updateRoster(roster1, false);
        ArrayList list = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)list.size(), (int)3);
        Assert.assertEquals((String)((ContactGroup)list.get(0)).getName(), (String)"Group1");
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(0)).getContacts().iterator().next()).getJid(), (Object)Jid.of((String)"contact1@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(1)).getName(), (String)"Group2");
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(1)).getContacts().iterator().next()).getJid(), (Object)Jid.of((String)"contact2@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(2)).getName(), (String)"Group3");
        Iterator iterator = ((ContactGroup)list.get(2)).getContacts().iterator();
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.of((String)"contact3@domain"));
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.of((String)"contact4@domain"));
        Assert.assertEquals((Object)((Contact)iterator.next()).getJid(), (Object)Jid.of((String)"contact5@domain"));
    }

    @Test
    public void testNestedRosterGroups() {
        TestXmppSession xmppSession1 = new TestXmppSession();
        RosterManager rosterManager = (RosterManager)xmppSession1.getManager(RosterManager.class);
        rosterManager.setGroupDelimiter("::");
        Roster roster1 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact3@domain"), "contact3", new String[]{"Group3::SubGroup"}), new Contact(Jid.of((String)"contact4@domain"), "contact4", new String[]{"Group3::SubGroup::3rdLevel"}), new Contact(Jid.of((String)"contact5@domain"), "contact5", new String[]{"Group3"})});
        rosterManager.updateRoster(roster1, false);
        ArrayList list = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertEquals((Object)((Contact)((ContactGroup)list.get(0)).getContacts().iterator().next()).getJid(), (Object)Jid.of((String)"contact5@domain"));
        Assert.assertEquals((String)((ContactGroup)list.get(0)).getName(), (String)"Group3");
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((int)((ContactGroup)list.get(0)).getGroups().size(), (int)1);
        ContactGroup contactGroup = (ContactGroup)((ContactGroup)list.get(0)).getGroups().iterator().next();
        Assert.assertEquals((String)contactGroup.getName(), (String)"SubGroup");
        Assert.assertEquals((int)contactGroup.getGroups().size(), (int)1);
        Assert.assertEquals((int)contactGroup.getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)contactGroup.getContacts().iterator().next()).getJid(), (Object)Jid.of((String)"contact3@domain"));
        ContactGroup nestedGroup = (ContactGroup)contactGroup.getGroups().iterator().next();
        Assert.assertEquals((String)nestedGroup.getName(), (String)"3rdLevel");
        Assert.assertEquals((int)nestedGroup.getContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)nestedGroup.getContacts().iterator().next()).getJid(), (Object)Jid.of((String)"contact4@domain"));
    }

    @Test
    public void testRosterIntegrity() {
        TestXmppSession xmppSession1 = new TestXmppSession();
        RosterManager rosterManager = (RosterManager)xmppSession1.getManager(RosterManager.class);
        Roster roster1 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact1@domain"), "contact1", new String[]{"group1"}), new Contact(Jid.of((String)"contact2@domain"), "contact2", new String[]{"group2"}), new Contact(Jid.of((String)"contact3@domain"), "contact3", Boolean.valueOf(true), null, Contact.Subscription.FROM, Collections.emptyList()), new Contact(Jid.of((String)"contact4@domain"), "contact4", Boolean.valueOf(true), null, Contact.Subscription.FROM, Collections.singleton("group2"))});
        rosterManager.updateRoster(roster1, false);
        Assert.assertEquals((int)rosterManager.getUnaffiliatedContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)rosterManager.getUnaffiliatedContacts().iterator().next()).getSubscription(), (Object)Contact.Subscription.FROM);
        ArrayList groups = new ArrayList(rosterManager.getContactGroups());
        Assert.assertEquals((int)((ContactGroup)groups.get(0)).getContacts().size(), (int)1);
        Assert.assertEquals((int)((ContactGroup)groups.get(1)).getContacts().size(), (int)2);
        Roster roster2 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact3@domain"), "contact3", Boolean.valueOf(true), null, Contact.Subscription.BOTH, Collections.emptyList())});
        rosterManager.updateRoster(roster2, true);
        Assert.assertEquals((int)rosterManager.getUnaffiliatedContacts().size(), (int)1);
        Assert.assertEquals((Object)((Contact)rosterManager.getUnaffiliatedContacts().iterator().next()).getSubscription(), (Object)Contact.Subscription.BOTH);
        Assert.assertEquals((int)rosterManager.getContactGroups().size(), (int)2);
        Roster roster3 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact2@domain"), "contact2", Boolean.valueOf(true), null, Contact.Subscription.TO, Collections.singleton("group1"))});
        rosterManager.updateRoster(roster3, true);
        groups = new ArrayList(rosterManager.getContactGroups());
        ArrayList contacts = new ArrayList(((ContactGroup)groups.get(0)).getContacts());
        Assert.assertEquals((int)((ContactGroup)groups.get(0)).getContacts().size(), (int)2);
        Assert.assertEquals((Object)((Contact)contacts.get(1)).getSubscription(), (Object)Contact.Subscription.TO);
        Assert.assertTrue((boolean)((Contact)contacts.get(1)).isPending());
        Assert.assertEquals((int)((ContactGroup)groups.get(1)).getContacts().size(), (int)1);
        Roster roster4 = new Roster(new Contact[]{new Contact(Jid.of((String)"contact3@domain"), "", Boolean.valueOf(false), null, Contact.Subscription.REMOVE, Collections.emptyList())});
        rosterManager.updateRoster(roster4, true);
        Assert.assertTrue((boolean)rosterManager.getUnaffiliatedContacts().isEmpty());
    }
}

