/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.cache;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.util.cache.DirectoryCache;

public class DirectoryCacheTest {
    private static void deleteDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryCache() throws IOException {
        Path file = Files.createTempDirectory(Paths.get(".", new String[0]), "cache_test", new FileAttribute[0]);
        DirectoryCache cache = new DirectoryCache(file);
        try {
            byte[] data = new byte[]{1, 2, 3};
            Assert.assertEquals((int)cache.size(), (int)0);
            Assert.assertFalse((boolean)cache.containsKey((Object)"1"));
            Assert.assertTrue((boolean)cache.isEmpty());
            Assert.assertNull((Object)cache.put("1", data));
            Assert.assertNotNull((Object)cache.put("1", data));
            byte[] loaded = cache.get((Object)"1");
            Assert.assertEquals((byte[])loaded, (byte[])data);
            Assert.assertEquals((int)cache.size(), (int)1);
            Assert.assertTrue((boolean)cache.containsKey((Object)"1"));
            Assert.assertFalse((boolean)cache.isEmpty());
            Assert.assertNull((Object)cache.remove((Object)"0"));
            Assert.assertEquals((byte[])cache.remove((Object)"1"), (byte[])new byte[]{1, 2, 3});
            Assert.assertTrue((boolean)cache.isEmpty());
            cache.put("1", data);
            cache.put("2", data);
            cache.put("3", data);
            Assert.assertEquals((int)cache.size(), (int)3);
            cache.clear();
            Assert.assertTrue((boolean)cache.isEmpty());
        }
        finally {
            DirectoryCacheTest.deleteDirectory(file);
        }
    }
}

