/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import rocks.xmpp.core.sasl.AuthenticationException;
import rocks.xmpp.core.sasl.XmppSaslClientFactory;
import rocks.xmpp.core.sasl.model.Auth;
import rocks.xmpp.core.sasl.model.Challenge;
import rocks.xmpp.core.sasl.model.Failure;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.sasl.model.Response;
import rocks.xmpp.core.sasl.model.Success;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;

final class AuthenticationManager
extends StreamFeatureNegotiator {
    private final List<String> supportedMechanisms = new ArrayList<String>();
    private SaslClient saslClient;
    private byte[] successData;

    AuthenticationManager(XmppSession xmppSession) {
        super(xmppSession, Mechanisms.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startAuthentication(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler) throws StreamNegotiationException {
        AuthenticationManager authenticationManager = this;
        synchronized (authenticationManager) {
            try {
                ArrayDeque<String> clientMechanisms = new ArrayDeque<String>(mechanisms);
                clientMechanisms.retainAll(this.supportedMechanisms);
                if (clientMechanisms.isEmpty()) {
                    throw new StreamNegotiationException("Server doesn't support any of the requested SASL mechanisms: " + mechanisms + ".");
                }
                this.successData = null;
                this.saslClient = Sasl.createSaslClient(clientMechanisms.toArray(new String[clientMechanisms.size()]), authorizationId, "xmpp", this.xmppSession.getDomain().toString(), new HashMap(), callbackHandler);
                if (this.saslClient == null) {
                    throw new SaslException("No SASL client found for mechanisms: " + clientMechanisms);
                }
                byte[] initialResponse = new byte[]{};
                if (this.saslClient.hasInitialResponse()) {
                    initialResponse = this.saslClient.evaluateChallenge(new byte[0]);
                }
                this.xmppSession.send((StreamElement)new Auth(this.saslClient.getMechanismName(), initialResponse));
            }
            catch (SaslException e) {
                throw new StreamNegotiationException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
        try {
            AuthenticationManager authenticationManager = this;
            synchronized (authenticationManager) {
                if (element instanceof Mechanisms) {
                    this.supportedMechanisms.clear();
                    this.supportedMechanisms.addAll(((Mechanisms)element).getMechanisms());
                } else if (element instanceof Challenge) {
                    this.xmppSession.send((StreamElement)new Response(this.saslClient.evaluateChallenge(((Challenge)element).getValue())));
                } else {
                    if (element instanceof Failure) {
                        Failure authenticationFailure = (Failure)element;
                        String failureText = this.saslClient.getMechanismName() + " authentication failed with condition " + authenticationFailure.toString();
                        if (authenticationFailure.getText() != null) {
                            failureText = failureText + " (" + authenticationFailure.getText() + ')';
                        }
                        throw new AuthenticationException(failureText, authenticationFailure);
                    }
                    if (element instanceof Success) {
                        this.successData = ((Success)element).getAdditionalData();
                        return StreamFeatureNegotiator.Status.SUCCESS;
                    }
                }
            }
        }
        catch (SaslException e) {
            throw new StreamNegotiationException(e);
        }
        return StreamFeatureNegotiator.Status.INCOMPLETE;
    }

    @Override
    public final boolean needsRestart() {
        return true;
    }

    @Override
    public final boolean canProcess(Object element) {
        return element instanceof Challenge || element instanceof Failure || element instanceof Success;
    }

    synchronized byte[] getSuccessData() {
        return this.successData;
    }

    static {
        Security.addProvider(new Provider("XMPP Sasl Provider", 1.0, "Provides additional SASL mechanisms, which are required for XMPP."){
            {
                this.put("SaslClientFactory.ANONYMOUS", XmppSaslClientFactory.class.getName());
                this.put("SaslClientFactory.SCRAM-SHA-1", XmppSaslClientFactory.class.getName());
            }
        });
    }
}

