/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.ConnectionException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.StreamErrorException;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.util.XmppUtils;

public abstract class XmppSession
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(XmppSession.class.getName());
    private static final EnumSet<Status> IS_CONNECTED = EnumSet.of(Status.CONNECTED, Status.AUTHENTICATED, Status.AUTHENTICATING);
    protected final List<Connection> connections = new ArrayList<Connection>();
    protected final XmppSessionConfiguration configuration;
    protected final ServiceDiscoveryManager serviceDiscoveryManager;
    protected final StreamFeaturesManager streamFeaturesManager;
    private final Set<Consumer<MessageEvent>> inboundMessageListeners = new CopyOnWriteArraySet<Consumer<MessageEvent>>();
    private final Set<Consumer<MessageEvent>> outboundMessageListeners = new CopyOnWriteArraySet<Consumer<MessageEvent>>();
    private final Set<Consumer<PresenceEvent>> inboundPresenceListeners = new CopyOnWriteArraySet<Consumer<PresenceEvent>>();
    private final Set<Consumer<PresenceEvent>> outboundPresenceListeners = new CopyOnWriteArraySet<Consumer<PresenceEvent>>();
    private final Set<Consumer<IQEvent>> inboundIQListeners = new CopyOnWriteArraySet<Consumer<IQEvent>>();
    private final Set<Consumer<IQEvent>> outboundIQListeners = new CopyOnWriteArraySet<Consumer<IQEvent>>();
    private final Map<Class<?>, IQHandler> iqHandlerMap = new HashMap();
    private final Map<Class<?>, Boolean> iqHandlerInvocationModes = new HashMap();
    private final Set<Consumer<SessionStatusEvent>> sessionStatusListeners = new CopyOnWriteArraySet<Consumer<SessionStatusEvent>>();
    private final Map<Class<? extends Manager>, Manager> instances = new ConcurrentHashMap<Class<? extends Manager>, Manager>();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INITIAL);
    protected volatile Connection activeConnection;
    protected volatile Jid xmppServiceDomain;
    protected volatile Throwable exception;
    protected volatile boolean wasLoggedIn;
    ExecutorService iqHandlerExecutor;
    ExecutorService stanzaListenerExecutor;
    private volatile Thread shutdownHook;
    private volatile XmppDebugger debugger;

    protected XmppSession(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        this.xmppServiceDomain = xmppServiceDomain != null && !xmppServiceDomain.isEmpty() ? Jid.of((String)xmppServiceDomain) : null;
        this.configuration = configuration;
        this.stanzaListenerExecutor = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"Stanza Listener Thread"));
        this.iqHandlerExecutor = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"IQ Handler Thread"));
        this.serviceDiscoveryManager = this.getManager(ServiceDiscoveryManager.class);
        this.streamFeaturesManager = this.getManager(StreamFeaturesManager.class);
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                XmppSession.this.shutdownHook = null;
                try {
                    XmppSession.this.close();
                }
                catch (XmppException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (configuration.getDebugger() != null) {
            try {
                this.debugger = configuration.getDebugger().newInstance();
                this.debugger.initialize(this);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (connectionConfigurations.length == 0) {
            this.connections.add(TcpConnectionConfiguration.getDefault().createConnection(this));
            this.connections.add(BoshConnectionConfiguration.getDefault().createConnection(this));
        } else {
            Arrays.stream(connectionConfigurations).map(connectionConfiguration -> connectionConfiguration.createConnection(this)).forEach(this.connections::add);
        }
        configuration.getExtensions().forEach(this.serviceDiscoveryManager::registerFeature);
    }

    static boolean isSentToUserOrServer(Stanza stanza, Jid domain, Jid connectedResource) {
        if (stanza instanceof Presence) {
            return false;
        }
        if (stanza.getTo() == null) {
            return true;
        }
        Jid toBare = stanza.getTo().asBareJid();
        return connectedResource != null && toBare.equals((Object)connectedResource.asBareJid()) || domain != null && (toBare.equals((Object)domain) || toBare.toString().endsWith("." + domain.toEscapedString()));
    }

    protected static void throwAsXmppExceptionIfNotNull(Throwable e) throws XmppException {
        if (e != null) {
            if (e instanceof XmppException) {
                throw (XmppException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new XmppException(e);
        }
    }

    public final void connect() throws XmppException {
        this.connect(null);
    }

    public abstract void connect(Jid var1) throws XmppException;

    protected final void tryConnect(Jid from, String namespace, Consumer<Jid> onStreamOpened) throws XmppException {
        Iterator<Connection> connectionIterator = this.getConnections().iterator();
        while (connectionIterator.hasNext()) {
            Connection connection = connectionIterator.next();
            try {
                connection.connect(from, namespace, onStreamOpened);
                this.activeConnection = connection;
                break;
            }
            catch (IOException e) {
                if (connectionIterator.hasNext()) {
                    logger.log(Level.WARNING, "{0} failed to connect. Trying alternative connection.", connection);
                    logger.log(Level.FINE, e.getMessage(), e);
                    continue;
                }
                throw new ConnectionException(e);
            }
        }
        logger.log(Level.FINE, "Connected via {0}", this.activeConnection);
    }

    protected final void onConnectionFailed(Status previousStatus, Throwable e) throws XmppException {
        try {
            if (this.activeConnection != null) {
                this.activeConnection.close();
                this.activeConnection = null;
            }
        }
        catch (Exception e1) {
            e.addSuppressed(e1);
        }
        this.updateStatus(previousStatus, e);
        XmppSession.throwAsXmppExceptionIfNotNull(e);
    }

    protected final Status preLogin() {
        Status previousStatus = this.getStatus();
        if (previousStatus == Status.AUTHENTICATED || !this.updateStatus(Status.AUTHENTICATING)) {
            throw new IllegalStateException("You are already logged in.");
        }
        if (previousStatus != Status.CONNECTED) {
            throw new IllegalStateException("You must be connected to the server before trying to login.");
        }
        if (this.getDomain() == null) {
            throw new IllegalStateException("The XMPP domain must not be null.");
        }
        this.exception = null;
        return previousStatus;
    }

    public final void addInboundMessageListener(Consumer<MessageEvent> messageListener) {
        this.inboundMessageListeners.add(messageListener);
    }

    public final void removeInboundMessageListener(Consumer<MessageEvent> messageListener) {
        this.inboundMessageListeners.remove(messageListener);
    }

    public final void addOutboundMessageListener(Consumer<MessageEvent> messageListener) {
        this.outboundMessageListeners.add(messageListener);
    }

    public final void removeOutboundMessageListener(Consumer<MessageEvent> messageListener) {
        this.outboundMessageListeners.remove(messageListener);
    }

    public final void addInboundPresenceListener(Consumer<PresenceEvent> presenceListener) {
        this.inboundPresenceListeners.add(presenceListener);
    }

    public final void removeInboundPresenceListener(Consumer<PresenceEvent> presenceListener) {
        this.inboundPresenceListeners.remove(presenceListener);
    }

    public final void addOutboundPresenceListener(Consumer<PresenceEvent> presenceListener) {
        this.outboundPresenceListeners.add(presenceListener);
    }

    public final void removeOutboundPresenceListener(Consumer<PresenceEvent> presenceListener) {
        this.outboundPresenceListeners.remove(presenceListener);
    }

    public final void addInboundIQListener(Consumer<IQEvent> iqListener) {
        this.inboundIQListeners.add(iqListener);
    }

    public final void removeInboundIQListener(Consumer<IQEvent> iqListener) {
        this.inboundIQListeners.remove(iqListener);
    }

    public final void addOutboundIQListener(Consumer<IQEvent> iqListener) {
        this.outboundIQListeners.add(iqListener);
    }

    public final void removeOutboundIQListener(Consumer<IQEvent> iqListener) {
        this.outboundIQListeners.remove(iqListener);
    }

    public final void addIQHandler(Class<?> type, IQHandler iqHandler) {
        this.addIQHandler(type, iqHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIQHandler(Class<?> type, IQHandler iqHandler, boolean invokeAsync) {
        Map<Class<?>, IQHandler> map = this.iqHandlerMap;
        synchronized (map) {
            this.iqHandlerMap.put(type, iqHandler);
            this.iqHandlerInvocationModes.put(type, invokeAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeIQHandler(Class<?> type) {
        Map<Class<?>, IQHandler> map = this.iqHandlerMap;
        synchronized (map) {
            this.iqHandlerMap.remove(type);
            this.iqHandlerInvocationModes.remove(type);
        }
    }

    public final void addSessionStatusListener(Consumer<SessionStatusEvent> sessionStatusListener) {
        this.sessionStatusListeners.add(sessionStatusListener);
    }

    public final void removeSessionStatusListener(Consumer<SessionStatusEvent> sessionStatusListener) {
        this.sessionStatusListeners.remove(sessionStatusListener);
    }

    public IQ query(IQ iq) throws XmppException {
        return this.query(iq, this.configuration.getDefaultResponseTimeout());
    }

    public IQ query(IQ iq, long timeout) throws XmppException {
        if (!iq.isRequest()) {
            throw new IllegalArgumentException("IQ must be of type 'get' or 'set'");
        }
        return this.sendAndAwait((StreamElement)iq, IQEvent::getIQ, responseIQ -> responseIQ.isResponse() && responseIQ.getId() != null && responseIQ.getId().equals(iq.getId()), this::addInboundIQListener, this::removeInboundIQListener, timeout);
    }

    public final Presence sendAndAwaitPresence(StreamElement stanza, Predicate<Presence> filter) throws XmppException {
        return this.sendAndAwait(stanza, PresenceEvent::getPresence, filter, this::addInboundPresenceListener, this::removeInboundPresenceListener, this.configuration.getDefaultResponseTimeout());
    }

    public final Message sendAndAwaitMessage(StreamElement stanza, Predicate<Message> filter) throws XmppException {
        return this.sendAndAwait(stanza, MessageEvent::getMessage, filter, this::addInboundMessageListener, this::removeInboundMessageListener, this.configuration.getDefaultResponseTimeout());
    }

    private <S extends Stanza, E extends EventObject> S sendAndAwait(StreamElement stanza, Function<E, S> stanzaMapper, Predicate<S> filter, Consumer<Consumer<E>> addListener, Consumer<Consumer<E>> removeListener, long timeout) throws XmppException {
        Stanza[] result = new Stanza[1];
        ReentrantLock lock = new ReentrantLock();
        java.util.concurrent.locks.Condition resultReceived = lock.newCondition();
        Consumer<EventObject> listener = e -> {
            Stanza st = (Stanza)stanzaMapper.apply(e);
            if (filter.test(st)) {
                lock.lock();
                try {
                    stanzaArray[0] = st;
                }
                finally {
                    resultReceived.signalAll();
                    lock.unlock();
                }
            }
        };
        lock.lock();
        try {
            addListener.accept(listener);
            this.send(stanza);
            if (!resultReceived.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Timeout reached, while waiting on a response.");
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new XmppException("Thread is interrupted.", (Throwable)e2);
        }
        finally {
            lock.unlock();
            removeListener.accept(listener);
        }
        Stanza response = result[0];
        if (response.getError() != null) {
            throw new StanzaException(response);
        }
        return (S)response;
    }

    public final Connection getActiveConnection() {
        return this.activeConnection;
    }

    protected final void setXmppServiceDomain(Jid xmppServiceDomain) {
        this.xmppServiceDomain = xmppServiceDomain;
    }

    public StreamElement send(StreamElement element) {
        if (!this.isConnected() && !EnumSet.of(Status.CLOSING, Status.CONNECTING).contains((Object)this.getStatus())) {
            throw new IllegalStateException("Session is not connected to server");
        }
        if (element instanceof Stanza) {
            Stanza stanza = (Stanza)element;
            if (!EnumSet.of(Status.AUTHENTICATED, Status.CLOSING).contains((Object)this.getStatus()) && !XmppSession.isSentToUserOrServer(stanza, this.getDomain(), this.getConnectedResource())) {
                throw new IllegalStateException("Cannot send stanzas before resource binding has completed.");
            }
            if (stanza instanceof Message) {
                XmppUtils.notifyEventListeners(this.outboundMessageListeners, (EventObject)new MessageEvent((Object)this, (Message)stanza, false));
            } else if (stanza instanceof Presence) {
                XmppUtils.notifyEventListeners(this.outboundPresenceListeners, (EventObject)new PresenceEvent((Object)this, (Presence)stanza, false));
            } else if (stanza instanceof IQ) {
                XmppUtils.notifyEventListeners(this.outboundIQListeners, (EventObject)new IQEvent((Object)this, (IQ)stanza, false));
            }
        }
        if (this.activeConnection == null) {
            throw new IllegalStateException("No connection established.");
        }
        this.activeConnection.send(element);
        return element;
    }

    public final Status getStatus() {
        return this.status.get();
    }

    protected final boolean updateStatus(Status status) {
        return this.updateStatus(status, null);
    }

    protected final boolean updateStatus(Status status, Throwable e) {
        Status oldStatus = this.status.getAndSet(status);
        if (status != oldStatus) {
            XmppUtils.notifyEventListeners(this.sessionStatusListeners, (EventObject)new SessionStatusEvent(this, status, oldStatus, e));
        }
        return status != oldStatus;
    }

    public final List<Connection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public final Unmarshaller createUnmarshaller() {
        try {
            return this.configuration.getJAXBContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public final Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.configuration.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            return marshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean isConnected() {
        return IS_CONNECTED.contains((Object)this.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleElement(Object element) throws XmppException {
        if (element instanceof IQ) {
            IQ iq = (IQ)element;
            if (iq.getType() == null) {
                this.send((StreamElement)iq.createError(Condition.BAD_REQUEST));
            } else if (iq.isRequest()) {
                Object payload = iq.getExtension(Object.class);
                if (payload == null) {
                    this.send((StreamElement)iq.createError(Condition.BAD_REQUEST));
                } else {
                    ExecutorService executor;
                    IQHandler iqHandler;
                    Map<Class<?>, IQHandler> map = this.iqHandlerMap;
                    synchronized (map) {
                        iqHandler = this.iqHandlerMap.get(payload.getClass());
                        executor = iqHandler != null ? (this.iqHandlerInvocationModes.get(payload.getClass()).booleanValue() ? this.iqHandlerExecutor : this.stanzaListenerExecutor) : null;
                    }
                    if (iqHandler != null) {
                        executor.execute(() -> {
                            try {
                                IQ response = iqHandler.handleRequest(iq);
                                if (response != null) {
                                    this.send((StreamElement)response);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, e, () -> "Failed to handle IQ request: " + e.getMessage());
                                this.send((StreamElement)iq.createError(Condition.SERVICE_UNAVAILABLE));
                            }
                        });
                    } else {
                        this.send((StreamElement)iq.createError(Condition.SERVICE_UNAVAILABLE));
                    }
                }
            }
            this.stanzaListenerExecutor.execute(() -> XmppUtils.notifyEventListeners(this.inboundIQListeners, (EventObject)new IQEvent((Object)this, iq, true)));
        } else if (element instanceof Message) {
            this.stanzaListenerExecutor.execute(() -> XmppUtils.notifyEventListeners(this.inboundMessageListeners, (EventObject)new MessageEvent((Object)this, (Message)element, true)));
        } else if (element instanceof Presence) {
            this.stanzaListenerExecutor.execute(() -> XmppUtils.notifyEventListeners(this.inboundPresenceListeners, (EventObject)new PresenceEvent((Object)this, (Presence)element, true)));
        } else if (element instanceof StreamFeatures) {
            this.streamFeaturesManager.processFeatures((StreamFeatures)element);
        } else {
            if (element instanceof StreamError) {
                throw new StreamErrorException((StreamError)element);
            }
            return this.streamFeaturesManager.processElement(element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Manager> T getManager(Class<T> clazz) {
        Manager instance = this.instances.get(clazz);
        if (instance == null) {
            Map<Class<? extends Manager>, Manager> map = this.instances;
            synchronized (map) {
                instance = this.instances.get(clazz);
                if (instance == null) {
                    try {
                        Constructor<T> constructor = clazz.getDeclaredConstructor(XmppSession.class);
                        constructor.setAccessible(true);
                        instance = (Manager)constructor.newInstance(this);
                        instance.initialize();
                        this.instances.put(clazz, instance);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException("Can't instantiate the provided class:" + clazz, e);
                    }
                }
            }
        }
        return (T)instance;
    }

    @Override
    public final void close() throws XmppException {
        if (this.getStatus() == Status.CLOSED || !this.updateStatus(Status.CLOSING)) {
            return;
        }
        try {
            if (this.activeConnection != null) {
                this.activeConnection.close();
                this.activeConnection = null;
            }
        }
        catch (Exception e) {
            XmppSession.throwAsXmppExceptionIfNotNull(e);
        }
        finally {
            this.inboundMessageListeners.clear();
            this.outboundMessageListeners.clear();
            this.inboundPresenceListeners.clear();
            this.outboundPresenceListeners.clear();
            this.inboundIQListeners.clear();
            this.outboundIQListeners.clear();
            this.stanzaListenerExecutor.shutdown();
            this.iqHandlerExecutor.shutdown();
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.updateStatus(Status.CLOSED);
            this.sessionStatusListeners.clear();
        }
    }

    public void notifyException(Throwable e) {
        this.exception = Objects.requireNonNull(e, "exception must not be null");
        this.streamFeaturesManager.cancelNegotiation();
        if (EnumSet.of(Status.AUTHENTICATED, Status.AUTHENTICATING, Status.CONNECTED, Status.CONNECTING).contains((Object)this.getStatus())) {
            try {
                this.activeConnection.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            if (this.updateStatus(Status.DISCONNECTED, e)) {
                logger.log(Level.FINE, "Session disconnected due to exception: ", e);
            }
        }
    }

    public final Jid getDomain() {
        return this.xmppServiceDomain;
    }

    public final XmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public final XmppDebugger getDebugger() {
        return this.debugger;
    }

    public final void enableFeature(String name) {
        this.serviceDiscoveryManager.addFeature(name);
    }

    public final void disableFeature(String name) {
        this.serviceDiscoveryManager.removeFeature(name);
    }

    public final void enableFeature(Class<? extends Manager> managerClass) {
        this.serviceDiscoveryManager.addFeature(managerClass);
    }

    public final void disableFeature(Class<? extends Manager> managerClass) {
        this.serviceDiscoveryManager.removeFeature(managerClass);
    }

    public final Set<String> getEnabledFeatures() {
        return this.serviceDiscoveryManager.getFeatures();
    }

    public abstract Jid getConnectedResource();

    public static enum Status {
        INITIAL,
        CONNECTING,
        CONNECTED,
        AUTHENTICATING,
        AUTHENTICATED,
        DISCONNECTED,
        CLOSING,
        CLOSED;

    }
}

