/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.session.Extension;
import rocks.xmpp.core.session.Module;
import rocks.xmpp.core.session.context.CoreContext;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Presence;

public final class XmppSessionConfiguration {
    private static final Path DEFAULT_APPLICATION_DATA_PATH;
    private static volatile XmppSessionConfiguration defaultConfiguration;
    private final JAXBContext jaxbContext;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private final Class<? extends XmppDebugger> xmppDebugger;
    private final int defaultResponseTimeout;
    private final List<String> authenticationMechanisms;
    private final Path cacheDirectory;
    private final Supplier<Presence> initialPresence;
    private final Set<Extension> extensions;

    private XmppSessionConfiguration(Builder builder) {
        this.xmppDebugger = builder.xmppDebugger;
        this.defaultResponseTimeout = builder.defaultResponseTimeout;
        this.authenticationMechanisms = builder.authenticationMechanisms;
        this.cacheDirectory = builder.cacheDirectory;
        this.initialPresence = builder.initialPresence;
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
        this.extensions = new HashSet(builder.context != null ? builder.context.getExtensions() : Collections.emptySet());
        this.extensions.addAll(builder.extensions);
        ServiceLoader<Module> loader = ServiceLoader.load(Module.class);
        for (Module module : loader) {
            this.extensions.addAll(module.getExtensions());
        }
        ArrayDeque classesToBeBound = new ArrayDeque();
        for (Extension extension : this.extensions) {
            classesToBeBound.addAll(extension.getClasses());
        }
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound.toArray(new Class[classesToBeBound.size()]));
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmppSessionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = XmppSessionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(XmppSessionConfiguration configuration) {
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public final Class<? extends XmppDebugger> getDebugger() {
        return this.xmppDebugger;
    }

    public final int getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public final List<String> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authenticationMechanisms);
    }

    public final Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public final Supplier<Presence> getInitialPresence() {
        return this.initialPresence;
    }

    final Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public final XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public final XMLOutputFactory getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    static {
        Path path;
        String appName = "xmpp.rocks";
        try {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                path = Paths.get(appData, new String[0]);
            } else {
                appData = System.getProperty("user.home");
                path = Paths.get(appData, "Library", "Application Support");
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(appData, new String[0]);
                }
            }
            path = path.resolve(appName);
        }
        catch (Exception e) {
            path = Paths.get(appName, new String[0]);
        }
        DEFAULT_APPLICATION_DATA_PATH = path;
    }

    public static final class Builder {
        private final Collection<Extension> extensions = new ArrayDeque<Extension>();
        private Class<? extends XmppDebugger> xmppDebugger;
        @Deprecated
        private CoreContext context;
        private int defaultResponseTimeout;
        private Path cacheDirectory;
        private Supplier<Presence> initialPresence;
        private List<String> authenticationMechanisms = Arrays.asList("SCRAM-SHA-1", "DIGEST-MD5", "GSSAPI", "CRAM-MD5", "PLAIN", "ANONYMOUS");

        private Builder() {
            this.defaultResponseTimeout(5000).cacheDirectory(DEFAULT_APPLICATION_DATA_PATH).initialPresence(Presence::new);
        }

        public final Builder debugger(Class<? extends XmppDebugger> xmppDebugger) {
            this.xmppDebugger = xmppDebugger;
            return this;
        }

        @Deprecated
        public final Builder context(CoreContext context) {
            this.context = context;
            return this;
        }

        public final Builder extensions(Extension ... extensions) {
            this.extensions.addAll(Arrays.asList(extensions));
            return this;
        }

        public final Builder defaultResponseTimeout(int defaultResponseTimeout) {
            this.defaultResponseTimeout = defaultResponseTimeout;
            return this;
        }

        public final Builder authenticationMechanisms(String ... authenticationMechanisms) {
            this.authenticationMechanisms = Arrays.asList(authenticationMechanisms);
            return this;
        }

        public final Builder cacheDirectory(Path path) {
            if (path != null && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("path is not a directory.");
            }
            this.cacheDirectory = path;
            return this;
        }

        public final Builder initialPresence(Supplier<Presence> presenceSupplier) {
            this.initialPresence = presenceSupplier;
            return this;
        }

        public final XmppSessionConfiguration build() {
            return new XmppSessionConfiguration(this);
        }
    }
}

