/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;

public abstract class AbstractIQHandler
implements IQHandler {
    private final IQ.Type type;

    protected AbstractIQHandler(IQ.Type type) {
        if (type != IQ.Type.GET && type != IQ.Type.SET) {
            throw new IllegalArgumentException("type must be 'get' or 'set'");
        }
        this.type = type;
    }

    @Override
    public final IQ handleRequest(IQ iq) {
        if (iq.getType() == this.type) {
            return this.processRequest(iq);
        }
        return iq.createError(new StanzaError(Condition.BAD_REQUEST, "Type was '" + iq.getType().toString().toLowerCase() + "', but expected '" + this.type.toString().toLowerCase() + "'."));
    }

    protected abstract IQ processRequest(IQ var1);
}

