/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamFeature;

public abstract class StreamFeatureNegotiator
extends Manager {
    private final Set<StreamFeatureListener> streamFeatureListeners = new CopyOnWriteArraySet<StreamFeatureListener>();
    private final Class<? extends StreamFeature> featureClass;

    public StreamFeatureNegotiator(XmppSession xmppSession, Class<? extends StreamFeature> featureClass) {
        super(xmppSession, false);
        this.featureClass = featureClass;
    }

    public final void addFeatureListener(StreamFeatureListener streamFeatureListener) {
        this.streamFeatureListeners.add(streamFeatureListener);
    }

    protected void notifyFeatureNegotiated() throws StreamNegotiationException {
        for (StreamFeatureListener streamFeatureListener : this.streamFeatureListeners) {
            streamFeatureListener.featureSuccessfullyNegotiated();
        }
    }

    public abstract Status processNegotiation(Object var1) throws StreamNegotiationException;

    public boolean needsRestart() {
        return false;
    }

    public abstract boolean canProcess(Object var1);

    public final Class<? extends StreamFeature> getFeatureClass() {
        return this.featureClass;
    }

    public static enum Status {
        SUCCESS,
        INCOMPLETE,
        IGNORE;

    }
}

