/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stream.model.StreamElement;

public final class PresenceManager
extends Manager {
    private final Map<Jid, Map<String, Presence>> presenceMap = new ConcurrentHashMap<Jid, Map<String, Presence>>();
    private final Map<String, Presence> lastSentPresences = new ConcurrentHashMap<String, Presence>();

    private PresenceManager(XmppSession xmppSession) {
        super(xmppSession, false);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addInboundPresenceListener(e -> {
            Presence presence = e.getPresence();
            if (presence.getFrom() != null) {
                Map presencesPerResource = this.presenceMap.computeIfAbsent(presence.getFrom().asBareJid(), key -> new ConcurrentHashMap());
                presencesPerResource.put(presence.getFrom().getResource() != null ? presence.getFrom().getResource() : "", presence);
            }
        });
        this.xmppSession.addOutboundPresenceListener(e -> {
            Presence presence = e.getPresence();
            if (presence.getType() == null || presence.getType() == Presence.Type.UNAVAILABLE) {
                if (presence.getTo() == null) {
                    this.lastSentPresences.put("", presence);
                } else {
                    this.lastSentPresences.put(presence.getTo().toString(), presence);
                }
            }
        });
    }

    public final Presence getPresence(Jid jid) {
        Map<String, Presence> presencesPerResource;
        if (Objects.requireNonNull(jid, "jid must not be null.").isBareJid()) {
            ArrayList<Presence> presences;
            presencesPerResource = this.presenceMap.get(jid);
            if (presencesPerResource != null && !(presences = new ArrayList<Presence>(presencesPerResource.values())).isEmpty()) {
                presences.sort(null);
                return (Presence)presences.get(0);
            }
        } else {
            Presence presence;
            presencesPerResource = this.presenceMap.get(jid.asBareJid());
            if (presencesPerResource != null && (presence = presencesPerResource.get(jid.getResource())) != null) {
                return presence;
            }
        }
        Presence presence = new Presence(Presence.Type.UNAVAILABLE);
        presence.setFrom(jid);
        return presence;
    }

    public final String requestSubscription(Jid jid, String status) {
        Presence presence = new Presence(jid.asBareJid(), Presence.Type.SUBSCRIBE, status, UUID.randomUUID().toString());
        this.xmppSession.send((StreamElement)presence);
        return presence.getId();
    }

    public final String approveSubscription(Jid jid) {
        Presence presence = new Presence(jid, Presence.Type.SUBSCRIBED, null, UUID.randomUUID().toString());
        this.xmppSession.send((StreamElement)presence);
        return presence.getId();
    }

    public final String denySubscription(Jid jid) {
        Presence presence = new Presence(jid, Presence.Type.UNSUBSCRIBED, null, UUID.randomUUID().toString());
        this.xmppSession.send((StreamElement)presence);
        return presence.getId();
    }

    public final String unsubscribe(Jid jid) {
        Presence presence = new Presence(jid, Presence.Type.UNSUBSCRIBE, null, UUID.randomUUID().toString());
        this.xmppSession.send((StreamElement)presence);
        return presence.getId();
    }

    public final Presence getLastSentPresence() {
        return this.lastSentPresences.get("");
    }

    public final Collection<Presence> getLastSentPresences() {
        return this.lastSentPresences.values();
    }
}

