/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.MockServer;
import rocks.xmpp.core.SameThreadExecutorService;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;

public final class TestXmppSession
extends XmppSession {
    private final MockServer mockServer;
    private final Jid connectedResource;

    public TestXmppSession() {
        this(Jid.of((CharSequence)"test@domain/resource"), new MockServer());
    }

    public TestXmppSession(Jid jid, MockServer mockServer) {
        this(jid, mockServer, XmppSessionConfiguration.getDefault());
    }

    public TestXmppSession(Jid jid, MockServer mockServer, XmppSessionConfiguration configuration) {
        super(null, configuration, new ConnectionConfiguration[0]);
        this.connectedResource = jid;
        this.activeConnection = new Connection(null, (ConnectionConfiguration)TcpConnectionConfiguration.builder().build()){

            protected void restartStream() {
            }

            public void send(StreamElement clientStreamElement) {
            }

            public void connect(Jid from, String namespace, Consumer<Jid> onConnected) throws IOException {
            }

            public boolean isSecure() {
                return false;
            }

            public String getStreamId() {
                return null;
            }

            public void close() throws IOException {
            }
        };
        this.stanzaListenerExecutor = this.iqHandlerExecutor = new SameThreadExecutorService();
        this.mockServer = mockServer;
        mockServer.registerConnection(this);
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
    }

    public StreamElement send(StreamElement element) {
        StreamElement sent = super.send(element);
        if (this.mockServer != null && sent instanceof Stanza) {
            ((Stanza)sent).setFrom(this.connectedResource);
            this.mockServer.receive((Stanza)sent);
        }
        return element;
    }

    public void connect(Jid from) throws XmppException {
    }

    public IQ query(IQ iq) throws XmppException {
        IQ[] result = new IQ[1];
        Consumer<IQEvent> iqListener = e -> {
            if (e.getIQ().isResponse() && e.getIQ().getId() != null && e.getIQ().getId().equals(iq.getId())) {
                iQArray[0] = e.getIQ();
            }
        };
        this.addInboundIQListener(iqListener);
        this.send((StreamElement)iq);
        this.removeInboundIQListener(iqListener);
        IQ response = result[0];
        if (response.getType() == IQ.Type.ERROR) {
            throw new StanzaException((Stanza)response);
        }
        return response;
    }

    public IQ query(IQ iq, long timeout) throws XmppException {
        return this.query(iq);
    }

    public Jid getConnectedResource() {
        return this.connectedResource;
    }
}

