/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.time.Instant;
import java.util.EventObject;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionEvent;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.ReconnectionStrategy;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.util.XmppUtils;

public final class ReconnectionManager
extends Manager {
    private static final Logger logger = Logger.getLogger(ReconnectionManager.class.getName());
    private final ScheduledExecutorService scheduledExecutorService;
    private ReconnectionStrategy reconnectionStrategy = ReconnectionStrategy.truncatedBinaryExponentialBackoffStrategy(60, 5);
    private ScheduledFuture<?> scheduledReconnection;
    private ScheduledFuture<?> scheduledReconnectingInterval;
    private Instant nextReconnectionAttempt;

    private ReconnectionManager(XmppSession xmppSession) {
        super(xmppSession, false);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Reconnection Thread"));
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case DISCONNECTED: {
                    if (e.getOldStatus() != XmppSession.Status.AUTHENTICATED) break;
                    XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.DISCONNECTED, e.getThrowable(), Duration.ZERO));
                    if (!this.reconnectionStrategy.mayReconnect(e.getThrowable())) break;
                    this.scheduleReconnection(0, e.getThrowable());
                    break;
                }
                case CONNECTED: {
                    this.cancel();
                    break;
                }
                case CLOSED: {
                    this.cancel();
                    this.scheduledExecutorService.shutdown();
                }
            }
        });
    }

    private synchronized void cancel() {
        if (this.scheduledReconnection != null) {
            this.scheduledReconnection.cancel(false);
            this.nextReconnectionAttempt = null;
        }
        if (this.scheduledReconnectingInterval != null) {
            this.scheduledReconnectingInterval.cancel(false);
        }
    }

    private synchronized void scheduleReconnection(int attempt, Throwable throwable) {
        if (this.isEnabled()) {
            long seconds = this.reconnectionStrategy.getNextReconnectionAttempt(attempt, throwable);
            if (attempt == 0) {
                logger.log(Level.FINE, "Disconnect detected. Next reconnection attempt in {0} seconds.", seconds);
            } else {
                logger.log(Level.FINE, "Still disconnected after {0} retries. Next reconnection attempt in {1} seconds.", new Object[]{attempt, seconds});
            }
            this.nextReconnectionAttempt = Instant.now().plusSeconds(seconds);
            this.scheduledReconnectingInterval = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Duration duration = Duration.between(Instant.now(), this.nextReconnectionAttempt);
                if (!duration.isNegative()) {
                    XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.RECONNECTION_PENDING, throwable, duration));
                } else {
                    ReconnectionManager reconnectionManager = this;
                    synchronized (reconnectionManager) {
                        this.scheduledReconnectingInterval.cancel(false);
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
            this.scheduledReconnection = this.scheduledExecutorService.schedule(() -> {
                try {
                    this.xmppSession.connect();
                    logger.log(Level.FINE, "Reconnection successful.");
                }
                catch (XmppException e) {
                    logger.log(Level.FINE, "Reconnection failed.", e);
                    XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.RECONNECTION_FAILED, e, Duration.ZERO));
                    this.scheduleReconnection(attempt + 1, e);
                }
            }, seconds, TimeUnit.SECONDS);
        }
    }

    public final synchronized ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public final synchronized void setReconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
        this.reconnectionStrategy = reconnectionStrategy;
    }

    public final synchronized Instant getNextReconnectionAttempt() {
        return this.nextReconnectionAttempt;
    }

    @Override
    protected final void onDisable() {
        super.onDisable();
        this.cancel();
    }
}

