/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.function.Consumer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.SecurityManager;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppStreamReader;
import rocks.xmpp.core.session.XmppStreamWriter;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionManager;
import rocks.xmpp.extensions.compress.CompressionMethod;

public final class TcpConnection
extends Connection {
    private final TcpConnectionConfiguration tcpConnectionConfiguration;
    String streamId;
    private Socket socket;
    private XmppStreamWriter xmppStreamWriter;
    private XmppStreamReader xmppStreamReader;
    private InputStream inputStream;
    private OutputStream outputStream;

    TcpConnection(XmppSession xmppSession, TcpConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.tcpConnectionConfiguration = configuration;
        StreamFeaturesManager streamFeaturesManager = xmppSession.getManager(StreamFeaturesManager.class);
        streamFeaturesManager.addFeatureNegotiator(new SecurityManager(xmppSession, () -> {
            try {
                this.secureConnection();
            }
            catch (Exception e) {
                throw new StreamNegotiationException(e);
            }
        }, configuration.isSecure()));
        CompressionManager compressionManager = xmppSession.getManager(CompressionManager.class);
        compressionManager.getConfiguredCompressionMethods().addAll(configuration.getCompressionMethods());
        compressionManager.addFeatureListener(() -> {
            OutputStream oStream;
            InputStream iStream;
            CompressionMethod compressionMethod = compressionManager.getNegotiatedCompressionMethod();
            TcpConnection tcpConnection = this;
            synchronized (tcpConnection) {
                iStream = this.inputStream;
                oStream = this.outputStream;
            }
            try {
                iStream = compressionMethod.decompress(iStream);
                oStream = compressionMethod.compress(oStream);
                tcpConnection = this;
                synchronized (tcpConnection) {
                    this.inputStream = iStream;
                    this.outputStream = oStream;
                }
            }
            catch (IOException e) {
                throw new StreamNegotiationException(e);
            }
        });
        streamFeaturesManager.addFeatureNegotiator(compressionManager);
    }

    @Override
    public final synchronized void connect(Jid from, String namespace, Consumer<Jid> onStreamOpened) throws IOException {
        if (this.socket != null) {
            return;
        }
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.getHostname() != null && !this.getHostname().isEmpty()) {
            this.connectToSocket(InetAddress.getByName(this.getHostname()), this.getPort(), this.getProxy());
        } else if (this.getXmppSession().getDomain() != null) {
            if (!this.connectWithXmppServiceDomain(this.getXmppSession().getDomain())) {
                this.connectToSocket(InetAddress.getByName(this.getXmppSession().getDomain().toString()), this.getPort(), this.getProxy());
            }
        } else {
            throw new IllegalStateException("Neither 'xmppServiceDomain' nor 'host' is set.");
        }
        this.from = from;
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        this.xmppStreamWriter = new XmppStreamWriter(namespace, this.getXmppSession());
        this.xmppStreamWriter.initialize(this.tcpConnectionConfiguration.getKeepAliveInterval());
        this.xmppStreamWriter.openStream(this.outputStream, from);
        this.xmppStreamReader = new XmppStreamReader(namespace, this, this.getXmppSession(), onStreamOpened);
        this.xmppStreamReader.startReading(this.inputStream);
    }

    @Override
    public synchronized boolean isSecure() {
        return this.socket instanceof SSLSocket;
    }

    private void connectToSocket(InetAddress inetAddress, int port, Proxy proxy) throws IOException {
        this.socket = this.tcpConnectionConfiguration.getSocketFactory() == null ? (proxy != null ? new Socket(proxy) : new Socket()) : this.tcpConnectionConfiguration.getSocketFactory().createSocket();
        this.socket.connect(new InetSocketAddress(inetAddress, port), this.tcpConnectionConfiguration.getConnectTimeout());
        this.port = port;
        this.hostname = inetAddress.getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secureConnection() throws IOException, CertificateException, NoSuchAlgorithmException {
        SSLSocket sslSocket;
        SSLContext sslContext = this.tcpConnectionConfiguration.getSSLContext();
        if (sslContext == null) {
            sslContext = SSLContext.getDefault();
        }
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            this.socket = sslContext.getSocketFactory().createSocket(this.socket, this.getXmppSession().getDomain().toString(), this.socket.getPort(), true);
            sslSocket = (SSLSocket)this.socket;
        }
        HostnameVerifier verifier = this.tcpConnectionConfiguration.getHostnameVerifier();
        if (verifier == null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParameters);
        } else {
            sslSocket.startHandshake();
            if (!verifier.verify(this.getXmppSession().getDomain().toString(), sslSocket.getSession())) {
                throw new CertificateException("Server failed to authenticate as " + this.getXmppSession().getDomain());
            }
        }
        TcpConnection tcpConnection2 = this;
        synchronized (tcpConnection2) {
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 65536);
        }
    }

    @Override
    public final synchronized void send(StreamElement element) {
        if (this.xmppStreamWriter != null) {
            this.xmppStreamWriter.send(element);
        }
    }

    @Override
    protected final synchronized void restartStream() {
        this.xmppStreamWriter.openStream(this.outputStream, this.from);
        this.xmppStreamReader.startReading(this.inputStream);
    }

    @Override
    public final synchronized void close() throws Exception {
        if (this.xmppStreamWriter != null) {
            this.xmppStreamWriter.shutdown();
            this.xmppStreamWriter = null;
        }
        if (this.xmppStreamReader != null) {
            this.xmppStreamReader.shutdown();
            this.xmppStreamReader = null;
        }
        this.inputStream = null;
        this.outputStream = null;
        this.streamId = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
    }

    private boolean connectWithXmppServiceDomain(Jid xmppServiceDomain) throws IOException {
        String query = "_xmpp-client._tcp." + xmppServiceDomain;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        if (this.tcpConnectionConfiguration.getConnectTimeout() > 0) {
            env.put("com.sun.jndi.dns.timeout.initial", String.valueOf(this.tcpConnectionConfiguration.getConnectTimeout()));
        }
        env.put("java.naming.provider.url", "dns:");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"SRV"});
            Attribute srvAttribute = attributes.get("SRV");
            ArrayList<DnsResourceRecord> dnsSrvRecords = new ArrayList<DnsResourceRecord>();
            if (srvAttribute != null) {
                NamingEnumeration<?> srvRecords = srvAttribute.getAll();
                while (srvRecords.hasMore()) {
                    String srvRecord = (String)srvRecords.next();
                    if (srvRecord == null) continue;
                    if (srvRecord.equals(".")) {
                        return false;
                    }
                    dnsSrvRecords.add(new DnsResourceRecord(srvRecord));
                }
                dnsSrvRecords.sort((o1, o2) -> {
                    int result = Integer.compare(o1.priority, o2.priority);
                    if (result == 0) {
                        result = Integer.compare(o2.weight, o1.weight);
                    }
                    return result;
                });
                IOException ex = null;
                for (DnsResourceRecord dnsResourceRecord : dnsSrvRecords) {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(dnsResourceRecord.target);
                        this.connectToSocket(inetAddress, dnsResourceRecord.port, this.getProxy());
                        return true;
                    }
                    catch (IOException e) {
                        ex = e;
                    }
                }
                if (dnsSrvRecords.size() > 0) {
                    throw new IOException("Could not connect to any host.", ex);
                }
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    @Override
    public final synchronized String getStreamId() {
        return this.streamId;
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("TCP connection");
        if (this.hostname != null) {
            sb.append(" to ").append(this.hostname).append(':').append(this.port);
        }
        if (this.streamId != null) {
            sb.append(" (").append(this.streamId).append(')');
        }
        if (this.from != null) {
            sb.append(", from: ").append((CharSequence)this.from);
        }
        return sb.toString();
    }

    private static final class DnsResourceRecord {
        final int priority;
        final int weight;
        final int port;
        final String target;

        DnsResourceRecord(String srvRecord) {
            String[] recordParts = srvRecord.split(" ");
            this.priority = Integer.parseInt(recordParts[recordParts.length - 4]);
            this.weight = Integer.parseInt(recordParts[recordParts.length - 3]);
            this.port = Integer.parseInt(recordParts[recordParts.length - 2]);
            String target = recordParts[recordParts.length - 1];
            this.target = target.substring(0, target.length() - 1);
        }
    }
}

