/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.bind.model.Bind;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.session.AuthenticationManager;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.ConnectionEvent;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.model.Session;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientMessage;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.im.roster.RosterManager;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;

public final class XmppClient
extends XmppSession {
    private static final Logger logger = Logger.getLogger(XmppClient.class.getName());
    private final AuthenticationManager authenticationManager = new AuthenticationManager(this);
    private volatile Jid connectedResource;
    private volatile String resource;
    private volatile String lastAuthorizationId;
    private volatile Collection<String> lastMechanisms;
    private volatile CallbackHandler lastCallbackHandler;
    private volatile boolean anonymous;

    public XmppClient(String xmppServiceDomain, ConnectionConfiguration ... connectionConfigurations) {
        this(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    public XmppClient(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        super(xmppServiceDomain, configuration, connectionConfigurations);
        this.streamFeaturesManager.addFeatureNegotiator(this.authenticationManager);
        this.streamFeaturesManager.addFeatureNegotiator(new StreamFeatureNegotiator(this, Bind.class){

            @Override
            public StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
                return StreamFeatureNegotiator.Status.INCOMPLETE;
            }

            @Override
            public boolean canProcess(Object element) {
                return false;
            }
        });
    }

    @Override
    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.getStatus();
        if (previousStatus == XmppSession.Status.CLOSED) {
            throw new IllegalStateException("Session is already closed. Create a new one.");
        }
        if (this.isConnected() || !this.updateStatus(XmppSession.Status.CONNECTING)) {
            logger.fine("Already connected. Return silently.");
            return;
        }
        this.exception = null;
        try {
            this.tryConnect(from, "jabber:client", this::setXmppServiceDomain);
            logger.fine("Negotiating stream, waiting until SASL is ready to be negotiated.");
            try {
                this.streamFeaturesManager.awaitNegotiation(Mechanisms.class, 10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
            logger.fine("Stream negotiated until SASL, now ready to login.");
            this.updateStatus(XmppSession.Status.CONNECTED);
            if (this.wasLoggedIn) {
                logger.fine("Was already logged in. Re-login automatically with known credentials.");
                this.login(this.lastMechanisms, this.lastAuthorizationId, this.lastCallbackHandler, this.resource);
                XmppUtils.notifyEventListeners((Iterable)this.connectionListeners, (EventObject)new ConnectionEvent(this, ConnectionEvent.Type.RECONNECTION_SUCCEEDED, null, Duration.ZERO));
            }
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    public final byte[] login(String user, String password) throws XmppException {
        return this.login(user, password, null);
    }

    public final byte[] login(String user, String password, String resource) throws XmppException {
        return this.login(null, user, password, resource);
    }

    public final byte[] login(String authorizationId, String user, String password, String resource) throws XmppException {
        Objects.requireNonNull(user, "user must not be null.");
        Objects.requireNonNull(password, "password must not be null.");
        return this.login(authorizationId, (Callback[] callbacks) -> Arrays.stream(callbacks).forEach(callback -> {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(user);
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(password.toCharArray());
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(((RealmCallback)callback).getDefaultText());
            }
        }), resource);
    }

    public final byte[] login(String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        return this.login(this.configuration.getAuthenticationMechanisms(), authorizationId, callbackHandler, resource);
    }

    public final byte[] loginAnonymously() throws XmppException {
        byte[] successData = this.login(Collections.singleton("ANONYMOUS"), null, null, null);
        this.anonymous = true;
        return successData;
    }

    private byte[] login(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        XmppSession.Status previousStatus = this.preLogin();
        this.lastMechanisms = mechanisms;
        this.lastAuthorizationId = authorizationId;
        this.lastCallbackHandler = callbackHandler;
        try {
            Presence initialPresence;
            PresenceManager presenceManager;
            logger.fine("Starting SASL negotiation (authentication).");
            if (callbackHandler == null) {
                this.authenticationManager.startAuthentication(mechanisms, null, null);
            } else {
                this.authenticationManager.startAuthentication(mechanisms, authorizationId, callbackHandler);
            }
            this.streamFeaturesManager.awaitNegotiation(Bind.class, this.configuration.getDefaultResponseTimeout());
            XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
            this.bindResource(resource);
            this.streamFeaturesManager.completeNegotiation(this.configuration.getDefaultResponseTimeout());
            XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
            logger.fine("Stream negotiation completed successfully.");
            RosterManager rosterManager = this.getManager(RosterManager.class);
            if (callbackHandler != null && rosterManager.isRetrieveRosterOnLogin()) {
                logger.fine("Retrieving roster on login (as per configuration).");
                rosterManager.requestRoster();
            }
            if ((presenceManager = this.getManager(PresenceManager.class)).getLastSentPresence() != null) {
                presenceManager.getLastSentPresences().forEach(presence -> {
                    presence.getExtensions().clear();
                    this.send((StreamElement)presence);
                });
            } else if (this.configuration.getInitialPresence() != null && (initialPresence = this.configuration.getInitialPresence().get()) != null) {
                this.send((StreamElement)initialPresence);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.updateStatus(previousStatus, e);
            XmppClient.throwAsXmppExceptionIfNotNull(e);
        }
        catch (Throwable e) {
            this.updateStatus(previousStatus, e);
            XmppClient.throwAsXmppExceptionIfNotNull(e);
        }
        logger.fine("Login successful.");
        return this.authenticationManager.getSuccessData();
    }

    private void bindResource(String resource) throws XmppException {
        this.resource = resource;
        logger.log(Level.FINE, "Negotiating resource binding, resource: {0}.", resource);
        IQ result = this.query(IQ.set((Object)new Bind(this.resource)));
        Bind bindResult = (Bind)result.getExtension(Bind.class);
        this.connectedResource = bindResult.getJid();
        logger.log(Level.FINE, "Resource binding completed, connected resource: {0}.", this.connectedResource);
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
        this.wasLoggedIn = true;
        Session session = (Session)this.streamFeaturesManager.getFeatures().get(Session.class);
        if (session != null && session.isMandatory()) {
            logger.fine("Establishing session.");
            this.query(IQ.set((Object)new Session()));
        }
    }

    @Override
    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public final StreamElement send(StreamElement element) {
        Object e = element instanceof Message ? ClientMessage.from((Message)((Message)element)) : (element instanceof Presence ? ClientPresence.from((Presence)((Presence)element)) : (element instanceof IQ ? ClientIQ.from((IQ)((IQ)element)) : element));
        super.send((StreamElement)e);
        return e;
    }

    public final boolean isSupported(String feature, Jid jid) throws XmppException {
        return this.getManager(EntityCapabilitiesManager.class).isSupported(feature, jid);
    }
}

