/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.cache.LruCache;

public final class EntityCapabilitiesManager
extends Manager {
    private static final Logger logger = Logger.getLogger(EntityCapabilitiesManager.class.getName());
    private static final String DEFAULT_NODE = "http://xmpp.rocks";
    private static final String HASH_ALGORITHM = "sha-1";
    private static final Map<Verification, InfoNode> CAPS_CACHE = new LruCache<Verification, InfoNode>(100);
    private static final Map<Jid, InfoNode> ENTITY_CAPABILITIES = new ConcurrentHashMap<Jid, InfoNode>();
    private static final Map<Jid, Lock> REQUESTING_LOCKS = new ConcurrentHashMap<Jid, Lock>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Map<String, Verification> publishedNodes;
    private final DirectoryCache directoryCapsCache;
    private final Consumer<PresenceEvent> inboundPresenceListener;
    private final Consumer<PresenceEvent> outboundPresenceListener;
    private boolean capsSent;
    private String node;

    private EntityCapabilitiesManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = xmppSession.getManager(ServiceDiscoveryManager.class);
        this.directoryCapsCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("caps")) : null;
        this.publishedNodes = new LinkedHashMap<String, Verification>(10, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Verification> eldest) {
                if (this.size() > 10) {
                    EntityCapabilitiesManager.this.serviceDiscoveryManager.removeInfoNode(eldest.getKey());
                    return true;
                }
                return false;
            }
        };
        this.inboundPresenceListener = e -> {
            EntityCapabilities entityCapabilities;
            Presence presence = e.getPresence();
            if (!presence.getFrom().equals((Object)xmppSession.getConnectedResource()) && (entityCapabilities = (EntityCapabilities)presence.getExtension(EntityCapabilities.class)) != null) {
                this.handleEntityCaps(entityCapabilities, presence.getFrom());
            }
        };
        this.outboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.isAvailable() && presence.getTo() == null) {
                Map<String, Verification> map = this.publishedNodes;
                synchronized (map) {
                    if (this.publishedNodes.isEmpty()) {
                        this.publishCapsNode();
                    }
                    ArrayList<Verification> verifications = new ArrayList<Verification>(this.publishedNodes.values());
                    Verification verification = (Verification)verifications.get(verifications.size() - 1);
                    presence.addExtension((Object)new EntityCapabilities(this.getNode(), verification.hashAlgorithm, verification.verificationString));
                    this.capsSent = true;
                }
            }
        };
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
    }

    @Override
    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
    }

    @Override
    protected void initialize() {
        this.serviceDiscoveryManager.addCapabilitiesChangeListener(evt -> {
            Map<String, Verification> map = this.publishedNodes;
            synchronized (map) {
                if (this.capsSent) {
                    this.publishCapsNode();
                    PresenceManager presenceManager = this.xmppSession.getManager(PresenceManager.class);
                    Presence lastPresence = presenceManager.getLastSentPresence();
                    this.xmppSession.send((StreamElement)new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null));
                }
            }
        });
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case AUTHENTICATED: {
                    EntityCapabilities serverCapabilities = (EntityCapabilities)this.xmppSession.getManager(StreamFeaturesManager.class).getFeatures().get(EntityCapabilities.class);
                    if (serverCapabilities == null) break;
                    this.handleEntityCaps(serverCapabilities, this.xmppSession.getDomain());
                }
            }
        });
    }

    private void publishCapsNode() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            final InfoDiscovery infoDiscovery = new InfoDiscovery(this.serviceDiscoveryManager.getIdentities(), this.serviceDiscoveryManager.getFeatures(), this.serviceDiscoveryManager.getExtensions());
            Verification verification = new Verification(HASH_ALGORITHM, EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest));
            this.writeToCache(verification, (InfoNode)infoDiscovery);
            final String node = this.getNode() + '#' + verification.verificationString;
            this.publishedNodes.put(node, verification);
            this.serviceDiscoveryManager.addInfoNode(new InfoNode(){

                public String getNode() {
                    return node;
                }

                public Set<Identity> getIdentities() {
                    return infoDiscovery.getIdentities();
                }

                public Set<String> getFeatures() {
                    return infoDiscovery.getFeatures();
                }

                public List<DataForm> getExtensions() {
                    return infoDiscovery.getExtensions();
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public synchronized String getNode() {
        return this.node != null ? this.node : DEFAULT_NODE;
    }

    public synchronized void setNode(String node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InfoNode discoverCapabilities(Jid jid) throws XmppException {
        InfoNode infoNode = ENTITY_CAPABILITIES.get(jid);
        if (infoNode == null) {
            Lock lock = REQUESTING_LOCKS.computeIfAbsent(jid, key -> new ReentrantLock());
            lock.lock();
            try {
                infoNode = ENTITY_CAPABILITIES.get(jid);
                if (infoNode != null) {
                    InfoNode infoNode2 = infoNode;
                    return infoNode2;
                }
                infoNode = this.serviceDiscoveryManager.discoverInformation(jid);
                ENTITY_CAPABILITIES.put(jid, infoNode);
            }
            finally {
                lock.unlock();
                REQUESTING_LOCKS.remove(jid);
            }
        }
        return infoNode;
    }

    public final boolean isSupported(String feature, Jid jid) throws XmppException {
        try {
            InfoNode infoNode = this.discoverCapabilities(jid);
            return infoNode.getFeatures().contains(feature);
        }
        catch (StanzaException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(Verification verification, InfoNode infoNode) {
        if (this.directoryCapsCache != null) {
            CAPS_CACHE.put(verification, infoNode);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(byteArrayOutputStream));
                    this.xmppSession.createMarshaller().marshal((Object)infoNode, xmppStreamWriter);
                    xmppStreamWriter.flush();
                }
                this.directoryCapsCache.put(XmppUtils.hash((byte[])verification.toString().getBytes(StandardCharsets.UTF_8)) + ".caps", byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e, () -> "Could not write entity capabilities to persistent cache. Reason: " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InfoNode readFromCache(Verification verification) {
        if (this.directoryCapsCache == null) return null;
        InfoNode infoNode2 = CAPS_CACHE.get(verification);
        if (infoNode2 != null) {
            return infoNode2;
        }
        String fileName = XmppUtils.hash((byte[])verification.toString().getBytes(StandardCharsets.UTF_8)) + ".caps";
        try {
            byte[] bytes = this.directoryCapsCache.get(fileName);
            if (bytes == null) return null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                infoNode2 = (InfoNode)this.xmppSession.createUnmarshaller().unmarshal((InputStream)byteArrayInputStream);
                CAPS_CACHE.put(verification, infoNode2);
                InfoNode infoNode = infoNode2;
                return infoNode;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e, () -> "Could not read entity capabilities from persistent cache (file: " + fileName + ')');
        }
        return null;
    }

    private void handleEntityCaps(EntityCapabilities entityCapabilities, Jid entity) {
        Verification verification = new Verification(entityCapabilities.getHashingAlgorithm(), entityCapabilities.getVerificationString());
        InfoNode infoNode = this.readFromCache(verification);
        if (entityCapabilities.getHashingAlgorithm() != null && infoNode != null) {
            ENTITY_CAPABILITIES.put(entity, infoNode);
        } else {
            String hashAlgorithm = entityCapabilities.getHashingAlgorithm();
            if (hashAlgorithm != null) {
                String nodeToDiscover = entityCapabilities.getNode() + '#' + entityCapabilities.getVerificationString();
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(entityCapabilities.getHashingAlgorithm());
                    InfoNode infoDiscovery = this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover);
                    ArrayDeque<String> ftValues = new ArrayDeque<String>();
                    for (DataForm dataForm : infoDiscovery.getExtensions()) {
                        DataForm.Field formType = dataForm.findField("FORM_TYPE");
                        if (formType == null || formType.getType() != DataForm.Field.Type.HIDDEN || formType.getValues().isEmpty()) continue;
                        ArrayDeque<String> values = new ArrayDeque<String>();
                        for (String value : formType.getValues()) {
                            if (values.contains(value)) {
                                return;
                            }
                            values.add(value);
                        }
                        String value = (String)formType.getValues().get(0);
                        if (ftValues.contains(value)) {
                            return;
                        }
                        ftValues.add(value);
                    }
                    String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest);
                    if (verificationString.equals(entityCapabilities.getVerificationString())) {
                        this.writeToCache(new Verification(hashAlgorithm, verificationString), infoDiscovery);
                    }
                    ENTITY_CAPABILITIES.put(entity, infoDiscovery);
                }
                catch (XmppException e1) {
                    logger.log(Level.WARNING, "Failed to discover information for entity ''{0}'' for node ''{1}''", new Object[]{entity, nodeToDiscover});
                }
                catch (NoSuchAlgorithmException e1) {
                    try {
                        ENTITY_CAPABILITIES.put(entity, this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover));
                    }
                    catch (XmppException e2) {
                        logger.log(Level.WARNING, "Failed to discover information for entity ''{0}'' for node ''{1}''", new Object[]{entity, nodeToDiscover});
                    }
                }
            }
        }
    }

    private static final class Verification {
        private final String hashAlgorithm;
        private final String verificationString;

        private Verification(String hashAlgorithm, String verificationString) {
            this.hashAlgorithm = hashAlgorithm;
            this.verificationString = verificationString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            return Objects.equals(this.hashAlgorithm, other.hashAlgorithm) && Objects.equals(this.verificationString, other.verificationString);
        }

        public int hashCode() {
            return Objects.hash(this.hashAlgorithm, this.verificationString);
        }

        public String toString() {
            return this.hashAlgorithm + '+' + this.verificationString;
        }
    }
}

