/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.chat;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.im.chat.ChatSession;
import rocks.xmpp.im.chat.ChatSessionEvent;
import rocks.xmpp.util.XmppUtils;

public final class ChatManager
extends Manager {
    private final Map<Jid, Map<String, ChatSession>> chatSessions = new ConcurrentHashMap<Jid, Map<String, ChatSession>>();
    private final Set<Consumer<ChatSessionEvent>> chatSessionListeners = new CopyOnWriteArraySet<Consumer<ChatSessionEvent>>();

    private ChatManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addInboundMessageListener(e -> {
            Message message = e.getMessage();
            if (message.getType() == Message.Type.CHAT) {
                String threadId;
                Jid chatPartner = message.getFrom();
                String string = threadId = message.getThread() != null ? message.getThread() : UUID.randomUUID().toString();
                if (chatPartner != null) {
                    Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
                    synchronized (map) {
                        ChatSession chatSession = this.buildChatSession(chatPartner, threadId, this.xmppSession, true);
                        chatSession.setChatPartner(message.getFrom());
                        XmppUtils.notifyEventListeners((Iterable)chatSession.inboundMessageListeners, (EventObject)new MessageEvent((Object)chatSession, message, true));
                    }
                }
            }
        });
        this.xmppSession.addInboundPresenceListener(e -> {
            Presence presence = e.getPresence();
            Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
            synchronized (map) {
                Jid contact = presence.getFrom().asBareJid();
                if (this.chatSessions.containsKey(contact)) {
                    for (ChatSession chatSession : this.chatSessions.get(contact).values()) {
                        chatSession.setChatPartner(contact);
                    }
                }
            }
        });
    }

    public void addChatSessionListener(Consumer<ChatSessionEvent> chatSessionListener) {
        this.chatSessionListeners.add(chatSessionListener);
    }

    public void removeChatSessionListener(Consumer<ChatSessionEvent> chatSessionListener) {
        this.chatSessionListeners.remove(chatSessionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatSession createChatSession(Jid chatPartner) {
        Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
        synchronized (map) {
            return this.buildChatSession(Objects.requireNonNull(chatPartner, "chatPartner must not be null."), UUID.randomUUID().toString(), this.xmppSession, false);
        }
    }

    private final ChatSession buildChatSession(Jid chatPartner, String threadId, XmppSession xmppSession, boolean inbound) {
        Jid contact = chatPartner.asBareJid();
        Map chatSessionMap = this.chatSessions.computeIfAbsent(contact, k -> new HashMap());
        return chatSessionMap.computeIfAbsent(threadId, k -> {
            ChatSession chatSession = new ChatSession(chatPartner, threadId, xmppSession, this);
            XmppUtils.notifyEventListeners(this.chatSessionListeners, (EventObject)new ChatSessionEvent(this, chatSession, inbound));
            return chatSession;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void destroyChatSession(ChatSession chatSession) {
        Jid user = Objects.requireNonNull(chatSession, "chatSession must not be null.").getChatPartner().asBareJid();
        Map<Jid, Map<String, ChatSession>> map = this.chatSessions;
        synchronized (map) {
            Map<String, ChatSession> chatSessionMap = this.chatSessions.get(user);
            if (chatSessionMap != null) {
                chatSessionMap.remove(chatSession.getThread());
                if (chatSessionMap.isEmpty()) {
                    this.chatSessions.remove(user);
                }
            }
        }
    }

    @Override
    protected void dispose() {
        this.chatSessionListeners.clear();
        this.chatSessions.clear();
    }
}

