/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;
import rocks.xmpp.util.XmppUtils;

public final class BoshConnection
extends Connection {
    private static final Logger logger = Logger.getLogger(BoshConnection.class.getName());
    final Map<Long, Body.Builder> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body.Builder>();
    private final AtomicLong rid = new AtomicLong();
    private final BoshConnectionConfiguration boshConnectionConfiguration;
    private final XmppDebugger debugger;
    private final Deque<String> keySequence = new ArrayDeque<String>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Map<String, CompressionMethod> compressionMethods;
    private final Collection<Object> elementsToSend = new ArrayDeque<Object>();
    private final String clientAcceptEncoding;
    private ExecutorService httpBindExecutor;
    private CompressionMethod requestCompressionMethod;
    private String requestContentEncoding;
    private long highestReceivedRid;
    private String sessionId;
    private String authId;
    private boolean usingAcknowledgments;
    private URL url;
    private Consumer<Jid> onStreamOpened;

    BoshConnection(XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.boshConnectionConfiguration = configuration;
        this.debugger = this.getXmppSession().getDebugger();
        this.compressionMethods = new LinkedHashMap<String, CompressionMethod>();
        for (CompressionMethod compressionMethod : this.boshConnectionConfiguration.getCompressionMethods()) {
            this.compressionMethods.put(compressionMethod.getName(), compressionMethod);
        }
        this.clientAcceptEncoding = !this.compressionMethods.isEmpty() ? String.join((CharSequence)",", this.compressionMethods.keySet()) : null;
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST, httpCode);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION, httpCode);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND, httpCode);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    private static String findBoshUrl(String xmppServiceDomain, long timeout) {
        try {
            String query = "_xmppconnect." + xmppServiceDomain;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            if (timeout > 0L) {
                env.put("com.sun.jndi.dns.timeout.initial", String.valueOf(timeout));
            }
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(query, new String[]{"TXT"});
            Attribute srvAttribute = attributes.get("TXT");
            if (srvAttribute != null) {
                NamingEnumeration<?> enumeration = srvAttribute.getAll();
                while (enumeration.hasMore()) {
                    String txtRecord = (String)enumeration.next();
                    String[] txtRecordParts = txtRecord.split("=");
                    String key = txtRecordParts[0];
                    String value = txtRecordParts[1];
                    if (!"_xmpp-client-xbosh".equals(key)) continue;
                    return value;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return null;
    }

    private void generateKeySequence() {
        this.keySequence.clear();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            SecureRandom random = new SecureRandom();
            int n = 256 + random.nextInt(32512);
            byte[] seed = new byte[1024];
            ((Random)random).nextBytes(seed);
            String kn = DatatypeConverter.printHexBinary((byte[])seed).toLowerCase();
            for (int i = 0; i < n; ++i) {
                kn = DatatypeConverter.printHexBinary((byte[])digest.digest(kn.getBytes(StandardCharsets.UTF_8))).toLowerCase();
                this.keySequence.add(kn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void connect(Jid from, String namespace, Consumer<Jid> onStreamOpened) throws IOException {
        if (this.sessionId != null) {
            return;
        }
        if (this.getXmppSession() == null) {
            throw new IllegalStateException("Can't connect without XmppSession. Use XmppSession to connect.");
        }
        if (this.url == null) {
            int targetPort;
            String protocol;
            String string = protocol = this.boshConnectionConfiguration.isSecure() ? "https" : "http";
            int n = this.getPort() > 0 ? this.getPort() : (targetPort = this.boshConnectionConfiguration.isSecure() ? 5281 : 5280);
            if (this.getHostname() != null) {
                this.url = new URL(protocol, this.getHostname(), targetPort, this.boshConnectionConfiguration.getPath());
            } else if (this.getXmppSession().getDomain() != null) {
                String resolvedUrl = BoshConnection.findBoshUrl(this.getXmppSession().getDomain().toString(), this.boshConnectionConfiguration.getConnectTimeout());
                this.url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, this.getXmppSession().getDomain().toString(), targetPort, this.boshConnectionConfiguration.getPath());
                this.port = this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort();
                this.hostname = this.url.getHost();
            } else {
                throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
            }
        }
        this.from = from;
        this.sessionId = null;
        this.authId = null;
        this.requestCount.set(0);
        this.onStreamOpened = onStreamOpened;
        this.rid.set(new BigInteger(52, new Random()).longValue());
        Body.Builder body = Body.builder().language(Locale.getDefault().getLanguage()).version("1.11").wait(this.boshConnectionConfiguration.getWait()).hold((byte)1).route(this.boshConnectionConfiguration.getRoute()).ack(1L).from(from).xmppVersion("1.0");
        if (this.getXmppSession().getDomain() != null) {
            body.to(this.getXmppSession().getDomain().toString());
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection();
            connection.setConnectTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.setReadTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.connect();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        this.httpBindExecutor = Executors.newFixedThreadPool(2, XmppUtils.createNamedThreadFactory((String)"XMPP BOSH Request Thread"));
        this.sendNewRequest(body, false);
    }

    @Override
    public final boolean isSecure() {
        return this.boshConnectionConfiguration.isSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBody(Body responseBody) throws Exception {
        if (responseBody.getSid() != null) {
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                this.sessionId = responseBody.getSid();
                this.authId = responseBody.getAuthId();
                if (responseBody.getAck() != null) {
                    this.usingAcknowledgments = true;
                }
                if (responseBody.getAccept() != null) {
                    String[] serverAcceptedEncodings;
                    for (String serverAcceptedEncoding : serverAcceptedEncodings = responseBody.getAccept().split(",")) {
                        this.requestCompressionMethod = this.compressionMethods.get(serverAcceptedEncoding);
                        this.requestContentEncoding = serverAcceptedEncoding;
                        if (this.requestCompressionMethod != null) break;
                    }
                }
                if (responseBody.getFrom() != null) {
                    this.onStreamOpened.accept(responseBody.getFrom());
                }
            }
        }
        if (responseBody.getAck() != null) {
            this.ackReceived(responseBody.getAck());
        }
        if (responseBody.getType() == Body.Type.TERMINATE && responseBody.getCondition() != null && responseBody.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
            this.shutdown();
            throw new BoshException(responseBody.getCondition(), responseBody.getUri());
        }
        if (responseBody.getType() == Body.Type.ERROR) {
            this.unacknowledgedRequests.entrySet().forEach(bodyBuilder -> this.sendNewRequest((Body.Builder)bodyBuilder.getValue(), true));
        }
        for (Object wrappedObject : responseBody.getWrappedObjects()) {
            if (!this.getXmppSession().handleElement(wrappedObject)) continue;
            this.restartStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void restartStream() {
        Body.Builder bodyBuilder;
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            bodyBuilder = Body.builder().sessionId(this.sessionId).restart(true).to(this.getXmppSession().getDomain().toString()).language(Locale.getDefault().getLanguage()).from(this.from);
        }
        this.sendNewRequest(bodyBuilder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws Exception {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                if (this.getSessionId() != null) {
                    Body.Builder bodyBuilder = Body.builder().sessionId(this.sessionId).type(Body.Type.TERMINATE);
                    this.sendNewRequest(bodyBuilder, false);
                }
                this.shutdown();
            }
            this.sessionId = null;
            this.authId = null;
            this.requestContentEncoding = null;
            this.keySequence.clear();
            this.requestContentEncoding = null;
        }
    }

    private synchronized void shutdown() {
        this.httpBindExecutor.shutdown();
        this.httpBindExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long detach() {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                this.httpBindExecutor.shutdown();
                this.httpBindExecutor = null;
            }
        }
        return this.rid.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void send(StreamElement element) {
        Body.Builder bodyBuilder = Body.builder().sessionId(this.getSessionId());
        Collection<Object> collection = this.elementsToSend;
        synchronized (collection) {
            this.elementsToSend.add(element);
        }
        this.sendNewRequest(bodyBuilder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendKey(Body.Builder bodyBuilder) {
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                if (this.keySequence.isEmpty()) {
                    this.generateKeySequence();
                    bodyBuilder.newKey(this.keySequence.removeLast());
                } else {
                    bodyBuilder.key(this.keySequence.removeLast());
                    if (this.keySequence.isEmpty()) {
                        this.generateKeySequence();
                        bodyBuilder.newKey(this.keySequence.removeLast());
                    }
                }
            }
        }
    }

    public final synchronized String getSessionId() {
        return this.sessionId;
    }

    @Override
    public final synchronized String getStreamId() {
        return this.authId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewRequest(Body.Builder bodyBuilder, boolean resendAfterError) {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor == null || this.httpBindExecutor.isShutdown()) {
                throw new IllegalStateException("Connection already shutdown via close() or detach()");
            }
            this.httpBindExecutor.execute(() -> {
                HttpURLConnection httpConnection = null;
                try {
                    block134: {
                        Throwable throwable;
                        Body body;
                        if (!resendAfterError) {
                            Collection<Object> collection = this.elementsToSend;
                            synchronized (collection) {
                                block132: {
                                    this.appendKey(bodyBuilder);
                                    if (!this.unacknowledgedRequests.isEmpty()) {
                                        bodyBuilder.ack(this.highestReceivedRid);
                                    }
                                    if ((body = bodyBuilder.wrappedObjects(this.elementsToSend).requestId(this.rid.get()).build()).getType() == Body.Type.TERMINATE || this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown() && (this.requestCount.get() <= 0 || body.getPause() != null || body.getRestart() != null && body.getRestart().booleanValue() || this.sessionId == null || !this.elementsToSend.isEmpty())) break block132;
                                    return;
                                }
                                this.rid.getAndIncrement();
                                this.elementsToSend.clear();
                            }
                        }
                        body = bodyBuilder.build();
                        if (this.usingAcknowledgments) {
                            this.unacknowledgedRequests.put(body.getRid(), bodyBuilder);
                        }
                        httpConnection = this.getConnection();
                        httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                        if (this.clientAcceptEncoding != null) {
                            httpConnection.setRequestProperty("Accept-Encoding", this.clientAcceptEncoding);
                        }
                        if (this.requestCompressionMethod != null && this.requestContentEncoding != null) {
                            httpConnection.setRequestProperty("Content-Encoding", this.requestContentEncoding);
                        }
                        httpConnection.setDoOutput(true);
                        httpConnection.setRequestMethod("POST");
                        httpConnection.setReadTimeout((this.boshConnectionConfiguration.getWait() + 5) * 1000);
                        this.requestCount.getAndIncrement();
                        try (AutoCloseable requestStream = this.requestCompressionMethod != null ? this.requestCompressionMethod.compress(httpConnection.getOutputStream()) : httpConnection.getOutputStream();){
                            ByteArrayOutputStream byteArrayOutputStreamRequest = new ByteArrayOutputStream();
                            throwable = null;
                            try (OutputStream branchedOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)requestStream, (OutputStream)byteArrayOutputStreamRequest);
                                 XMLStreamWriter xmlStreamWriter2 = null;
                                 OutputStream xmppOutputStream = this.debugger != null ? this.debugger.createOutputStream(branchedOutputStream) : branchedOutputStream;){
                                xmlStreamWriter2 = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.getXmppSession().getConfiguration().getXmlOutputFactory().createXMLStreamWriter(xmppOutputStream, "UTF-8"));
                                this.getXmppSession().createMarshaller().marshal((Object)body, xmlStreamWriter2);
                                xmlStreamWriter2.flush();
                                if (this.debugger != null) {
                                    this.debugger.writeStanza(byteArrayOutputStreamRequest.toString(), body);
                                }
                            }
                            catch (Throwable xmlStreamWriter2) {
                                throwable = xmlStreamWriter2;
                                throw xmlStreamWriter2;
                            }
                        }
                        if (httpConnection.getResponseCode() == 200) {
                            requestStream = this;
                            synchronized (requestStream) {
                                this.highestReceivedRid = body.getRid() != null ? body.getRid() : 0L;
                            }
                            String contentEncoding = httpConnection.getHeaderField("Content-Encoding");
                            try (InputStream responseStream = contentEncoding != null ? this.compressionMethods.get(contentEncoding).decompress(httpConnection.getInputStream()) : httpConnection.getInputStream();){
                                throwable = null;
                                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                     InputStream inputStream = XmppUtils.createBranchedInputStream((InputStream)responseStream, (OutputStream)byteArrayOutputStream);
                                     InputStream xmppInputStream = this.debugger != null ? this.debugger.createInputStream(inputStream) : inputStream;){
                                    XMLEventReader xmlEventReader = null;
                                    try {
                                        xmlEventReader = this.getXmppSession().getConfiguration().getXmlInputFactory().createXMLEventReader(xmppInputStream, "UTF-8");
                                        while (xmlEventReader.hasNext()) {
                                            XMLEvent xmlEvent = xmlEventReader.peek();
                                            if (xmlEvent.isStartElement()) {
                                                JAXBElement element = this.getXmppSession().createUnmarshaller().unmarshal(xmlEventReader, Body.class);
                                                if (this.debugger != null) {
                                                    this.debugger.readStanza(byteArrayOutputStream.toString(), element.getValue());
                                                }
                                                this.unpackBody((Body)element.getValue());
                                                continue;
                                            }
                                            xmlEventReader.next();
                                        }
                                        break block134;
                                    }
                                    catch (JAXBException e) {
                                        logger.log(Level.WARNING, "Server responded with malformed XML.", e);
                                        break block134;
                                    }
                                    finally {
                                        this.ackReceived(body.getRid());
                                        if (xmlEventReader != null) {
                                            xmlEventReader.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                        }
                        this.shutdown();
                        BoshConnection.handleCode(httpConnection.getResponseCode());
                        var6_8 = null;
                        try (InputStream errorStream = httpConnection.getErrorStream();){
                            while (errorStream.read() > -1) {
                            }
                        }
                        catch (Throwable throwable3) {
                            var6_8 = throwable3;
                            throw throwable3;
                        }
                    }
                    Thread.sleep(50L);
                    if (this.requestCount.decrementAndGet() == 0) {
                        this.sendNewRequest(Body.builder().sessionId(this.sessionId), false);
                    }
                }
                catch (Exception e) {
                    this.getXmppSession().notifyException(e);
                }
                finally {
                    if (httpConnection != null) {
                        httpConnection.disconnect();
                    }
                }
            });
        }
    }

    private void ackReceived(Long rid) {
        Body.Builder body;
        if (rid != null && (body = this.unacknowledgedRequests.remove(rid)) != null) {
            body.build().getWrappedObjects().stream().filter(object -> object instanceof Stanza).forEach(object -> {});
        }
    }

    private HttpURLConnection getConnection() throws IOException {
        Proxy proxy = this.getProxy();
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            if (this.boshConnectionConfiguration.getSSLContext() != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
            }
            if (this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.boshConnectionConfiguration.getHostnameVerifier());
            }
        }
        return httpURLConnection;
    }

    public final String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("BOSH connection");
        if (this.hostname != null) {
            sb.append(" to ").append(this.url);
        }
        if (this.sessionId != null) {
            sb.append(" (").append(this.sessionId).append(')');
        }
        if (this.from != null) {
            sb.append(", from: ").append((CharSequence)this.from);
        }
        return sb.toString();
    }
}

