/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class LruCache<K, V>
implements Map<K, V> {
    private final int maxEntries;
    private final ConcurrentHashMap<K, V> map;
    private final ConcurrentLinkedQueue<K> queue;

    public LruCache(int maxEntries) {
        this.maxEntries = maxEntries;
        this.map = new ConcurrentHashMap(maxEntries);
        this.queue = new ConcurrentLinkedQueue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.contains(value);
    }

    @Override
    public V get(Object key) {
        if (this.queue.remove(key)) {
            this.queue.offer(key);
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.map.put(key, value);
        if (oldValue != null) {
            if (this.queue.remove(key)) {
                this.queue.offer(key);
            }
        } else {
            this.queue.offer(key);
        }
        while (this.queue.size() > this.maxEntries) {
            K oldestKey = this.queue.poll();
            if (null == oldestKey) continue;
            this.map.remove(oldestKey);
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

