/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.SecurityManager;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppStreamReader;
import rocks.xmpp.core.session.XmppStreamWriter;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.SrvRecord;
import rocks.xmpp.extensions.compress.CompressionManager;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.extensions.sm.model.StreamManagement;

public final class TcpConnection
extends Connection {
    final StreamManager streamManager;
    private final TcpConnectionConfiguration tcpConnectionConfiguration;
    String streamId;
    private Socket socket;
    private XmppStreamWriter xmppStreamWriter;
    private XmppStreamReader xmppStreamReader;
    private InputStream inputStream;
    private OutputStream outputStream;

    TcpConnection(XmppSession xmppSession, TcpConnectionConfiguration configuration) {
        super(xmppSession, configuration);
        this.tcpConnectionConfiguration = configuration;
        this.streamManager = xmppSession.getManager(StreamManager.class);
    }

    void initialize() {
        StreamFeaturesManager streamFeaturesManager = this.xmppSession.getManager(StreamFeaturesManager.class);
        streamFeaturesManager.addFeatureNegotiator(new SecurityManager(this.xmppSession, () -> {
            try {
                this.secureConnection();
            }
            catch (Exception e) {
                throw new StreamNegotiationException(e);
            }
        }, this.tcpConnectionConfiguration.isSecure()));
        CompressionManager compressionManager = this.xmppSession.getManager(CompressionManager.class);
        compressionManager.getConfiguredCompressionMethods().addAll(this.tcpConnectionConfiguration.getCompressionMethods());
        compressionManager.addFeatureListener(() -> {
            OutputStream oStream;
            InputStream iStream;
            CompressionMethod compressionMethod = compressionManager.getNegotiatedCompressionMethod();
            TcpConnection tcpConnection = this;
            synchronized (tcpConnection) {
                iStream = this.inputStream;
                oStream = this.outputStream;
            }
            try {
                iStream = compressionMethod.decompress(iStream);
                oStream = compressionMethod.compress(oStream);
                tcpConnection = this;
                synchronized (tcpConnection) {
                    this.inputStream = iStream;
                    this.outputStream = oStream;
                }
            }
            catch (IOException e) {
                throw new StreamNegotiationException(e);
            }
        });
        streamFeaturesManager.addFeatureNegotiator(compressionManager);
        streamFeaturesManager.addFeatureNegotiator(this.streamManager);
    }

    @Override
    public final synchronized void connect(Jid from, String namespace, Consumer<Jid> onStreamOpened) throws IOException {
        if (this.socket != null) {
            if (!this.socket.isClosed() && this.socket.isConnected()) {
                return;
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getHostname() != null && !this.getHostname().isEmpty()) {
            this.socket = this.createAndConnectSocket(InetSocketAddress.createUnresolved(this.getHostname(), this.getPort()), this.getProxy());
        } else if (this.xmppSession.getDomain() != null) {
            if (!this.connectWithXmppServiceDomain(this.xmppSession.getDomain())) {
                this.socket = this.createAndConnectSocket(InetSocketAddress.createUnresolved(this.xmppSession.getDomain().toString(), this.getPort()), this.getProxy());
            }
        } else {
            throw new IllegalStateException("Neither 'xmppServiceDomain' nor 'host' is set.");
        }
        this.from = from;
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        this.xmppStreamWriter = new XmppStreamWriter(namespace, this.streamManager, this.xmppSession);
        this.xmppStreamWriter.initialize(this.tcpConnectionConfiguration.getKeepAliveInterval());
        this.xmppStreamWriter.openStream(this.outputStream, from);
        this.xmppStreamReader = new XmppStreamReader(namespace, this, this.xmppSession, onStreamOpened);
        this.xmppStreamReader.startReading(this.inputStream);
    }

    @Override
    public synchronized boolean isSecure() {
        return this.socket instanceof SSLSocket;
    }

    private Socket createAndConnectSocket(InetSocketAddress unresolvedAddress, Proxy proxy) throws IOException {
        Socket socket = this.tcpConnectionConfiguration.getSocketFactory() == null ? (proxy != null ? new Socket(proxy) : new Socket()) : this.tcpConnectionConfiguration.getSocketFactory().createSocket();
        if (!socket.isConnected()) {
            socket.connect(new InetSocketAddress(unresolvedAddress.getHostName(), unresolvedAddress.getPort()), this.tcpConnectionConfiguration.getConnectTimeout());
        }
        this.port = unresolvedAddress.getPort();
        this.hostname = unresolvedAddress.getHostName();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secureConnection() throws IOException, CertificateException, NoSuchAlgorithmException {
        SSLSocket sslSocket;
        SSLContext sslContext = this.tcpConnectionConfiguration.getSSLContext();
        if (sslContext == null) {
            sslContext = SSLContext.getDefault();
        }
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            this.socket = sslContext.getSocketFactory().createSocket(this.socket, this.xmppSession.getDomain().toString(), this.socket.getPort(), true);
            sslSocket = (SSLSocket)this.socket;
        }
        HostnameVerifier verifier = this.tcpConnectionConfiguration.getHostnameVerifier();
        if (verifier == null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParameters);
        } else {
            sslSocket.startHandshake();
            if (!verifier.verify(this.xmppSession.getDomain().toString(), sslSocket.getSession())) {
                throw new CertificateException("Server failed to authenticate as " + this.xmppSession.getDomain());
            }
        }
        TcpConnection tcpConnection2 = this;
        synchronized (tcpConnection2) {
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 65536);
        }
    }

    @Override
    public final synchronized Future<?> send(StreamElement element) {
        return this.xmppStreamWriter.send(element, () -> {
            if (element instanceof Stanza && this.streamManager.isActive() && this.streamManager.getRequestStrategy().test((Stanza)element)) {
                this.xmppStreamWriter.send((StreamElement)StreamManagement.REQUEST, null);
            }
        });
    }

    @Override
    protected final synchronized void restartStream() {
        this.xmppStreamWriter.openStream(this.outputStream, this.from);
        this.xmppStreamReader.startReading(this.inputStream);
    }

    @Override
    public final synchronized void close() throws Exception {
        if (this.xmppStreamWriter != null) {
            this.xmppStreamWriter.shutdown();
            this.xmppStreamWriter = null;
        }
        if (this.xmppStreamReader != null) {
            this.xmppStreamReader.shutdown();
            this.xmppStreamReader = null;
        }
        this.inputStream = null;
        this.outputStream = null;
        this.streamId = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectWithXmppServiceDomain(Jid xmppServiceDomain) {
        srvRecords = DnsResolver.resolveSRV("xmpp-client", (CharSequence)xmppServiceDomain, this.tcpConnectionConfiguration.getConnectTimeout());
        srvRecords.sort(null);
        ex = null;
        for (SrvRecord srvRecord : srvRecords) {
            if (srvRecord == null) continue;
            if (!".".equals(srvRecord.getTarget())) ** break block6
            return false;
        }
        ** GOTO lbl18
        {
            try {
                this.socket = this.createAndConnectSocket(InetSocketAddress.createUnresolved(srvRecord.getTarget(), srvRecord.getPort()), this.getProxy());
                return true;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    continue;
lbl18:
                    // 1 sources

                    if (srvRecords.isEmpty() != false) return false;
                    throw new IOException("Could not connect to any host.", ex);
                }
                catch (IOException e) {
                    return false;
                    break;
                }
            }
        }
    }

    @Override
    public final synchronized String getStreamId() {
        return this.streamId;
    }

    @Override
    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("TCP connection");
        if (this.hostname != null) {
            sb.append(" to ").append(this.hostname).append(':').append(this.port);
        }
        if (this.streamId != null) {
            sb.append(" (").append(this.streamId).append(')');
        }
        if (this.from != null) {
            sb.append(", from: ").append((CharSequence)this.from);
        }
        return sb.toString();
    }
}

