/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.util.XmppUtils;

final class XmppStreamWriter {
    private final XmppSession xmppSession;
    private final ScheduledExecutorService executor;
    private final Marshaller marshaller;
    private final XmppDebugger debugger;
    private final String namespace;
    private final StreamManager streamManager;
    private XMLStreamWriter prefixFreeCanonicalizationWriter;
    private XMLStreamWriter xmlStreamWriter;
    private ByteArrayOutputStream byteArrayOutputStream;
    private boolean streamOpened;

    XmppStreamWriter(String namespace, StreamManager streamManager, XmppSession xmppSession) {
        this.namespace = namespace;
        this.xmppSession = xmppSession;
        this.marshaller = xmppSession.createMarshaller();
        this.debugger = xmppSession.getDebugger();
        this.executor = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Writer Thread"));
        this.streamManager = streamManager;
    }

    void initialize(int keepAliveInterval) {
        if (keepAliveInterval > 0) {
            this.executor.scheduleAtFixedRate(() -> {
                if (EnumSet.of(XmppSession.Status.CONNECTED, XmppSession.Status.AUTHENTICATED).contains((Object)this.xmppSession.getStatus())) {
                    try {
                        this.xmlStreamWriter.writeCharacters(" ");
                        this.xmlStreamWriter.flush();
                    }
                    catch (Exception e) {
                        this.notifyException(e);
                    }
                }
            }, 0L, keepAliveInterval, TimeUnit.SECONDS);
        }
    }

    synchronized Future<?> send(StreamElement clientStreamElement, Runnable afterSend) {
        Objects.requireNonNull(clientStreamElement);
        return this.executor.submit(() -> {
            try {
                if (clientStreamElement instanceof Stanza) {
                    this.streamManager.markUnacknowledged((Stanza)clientStreamElement);
                }
                this.marshaller.marshal((Object)clientStreamElement, this.prefixFreeCanonicalizationWriter);
                this.prefixFreeCanonicalizationWriter.flush();
                if (clientStreamElement instanceof Stanza) {
                    this.prefixFreeCanonicalizationWriter.writeCharacters(" ");
                    this.prefixFreeCanonicalizationWriter.flush();
                }
                if (afterSend != null) {
                    afterSend.run();
                }
                if (this.debugger != null) {
                    this.debugger.writeStanza(new String(this.byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8).trim(), clientStreamElement);
                    this.byteArrayOutputStream.reset();
                }
            }
            catch (Exception e) {
                this.notifyException(e);
            }
        });
    }

    synchronized void openStream(OutputStream outputStream, Jid from) {
        if (!this.executor.isShutdown()) {
            this.executor.execute(() -> {
                try {
                    OutputStream xmppOutputStream = null;
                    if (this.debugger != null) {
                        this.byteArrayOutputStream = new ByteArrayOutputStream();
                        xmppOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)outputStream, (OutputStream)this.byteArrayOutputStream);
                        OutputStream debuggerOutputStream = this.debugger.createOutputStream(xmppOutputStream);
                        if (debuggerOutputStream != null) {
                            xmppOutputStream = debuggerOutputStream;
                        }
                    }
                    if (xmppOutputStream == null) {
                        xmppOutputStream = outputStream;
                    }
                    this.xmlStreamWriter = this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(xmppOutputStream, "UTF-8");
                    this.prefixFreeCanonicalizationWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmlStreamWriter, (String)this.namespace);
                    this.streamOpened = false;
                    this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
                    this.xmlStreamWriter.writeStartElement("stream", "stream", "http://etherx.jabber.org/streams");
                    this.xmlStreamWriter.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", this.xmppSession.getConfiguration().getLanguage().toLanguageTag());
                    if (this.xmppSession.getDomain() != null) {
                        this.xmlStreamWriter.writeAttribute("to", this.xmppSession.getDomain().toString());
                    }
                    if (from != null) {
                        this.xmlStreamWriter.writeAttribute("from", from.toEscapedString());
                    }
                    this.xmlStreamWriter.writeAttribute("version", "1.0");
                    this.xmlStreamWriter.writeNamespace("", this.namespace);
                    this.xmlStreamWriter.writeNamespace("stream", "http://etherx.jabber.org/streams");
                    this.xmlStreamWriter.writeCharacters("");
                    this.xmlStreamWriter.flush();
                    if (this.debugger != null) {
                        this.debugger.writeStanza(new String(this.byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8).trim(), null);
                        this.byteArrayOutputStream.reset();
                    }
                    this.streamOpened = true;
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            });
        }
    }

    private void closeStream() {
        this.executor.execute(() -> {
            if (this.streamOpened) {
                try {
                    this.xmlStreamWriter.writeEndElement();
                    this.xmlStreamWriter.flush();
                    if (this.debugger != null) {
                        this.debugger.writeStanza(new String(this.byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8).trim(), null);
                        this.byteArrayOutputStream.reset();
                    }
                    this.xmlStreamWriter.close();
                    this.streamOpened = false;
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Exception exception) {
        XmppStreamWriter xmppStreamWriter = this;
        synchronized (xmppStreamWriter) {
            this.executor.shutdown();
            if (this.prefixFreeCanonicalizationWriter != null) {
                try {
                    this.prefixFreeCanonicalizationWriter.close();
                    this.prefixFreeCanonicalizationWriter = null;
                }
                catch (Exception e) {
                    exception.addSuppressed(e);
                }
            }
            this.byteArrayOutputStream = null;
        }
        this.xmppSession.notifyException(exception);
    }

    synchronized void shutdown() {
        if (!this.executor.isShutdown()) {
            this.closeStream();
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

