/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import rocks.xmpp.core.stanza.model.Stanza;

public final class SendTask<S extends Stanza>
implements Future<Void> {
    private final S stanza;
    private Consumer<S> onAcknowledge;
    private boolean receivedByServer;
    CompletableFuture<Void> sendFuture;

    SendTask(S stanza) {
        this.stanza = stanza;
    }

    public final S getStanza() {
        return this.stanza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAcknowledge(Consumer<S> onAcknowledge) {
        boolean received;
        SendTask sendTask = this;
        synchronized (sendTask) {
            received = this.receivedByServer;
            this.onAcknowledge = onAcknowledge;
        }
        if (received) {
            onAcknowledge.accept(this.stanza);
        }
    }

    public final void onSent(Consumer<S> onSent) {
        this.sendFuture.thenRun(() -> onSent.accept(this.stanza));
    }

    public final void onFailed(BiConsumer<Throwable, S> onFailure) {
        this.sendFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                onFailure.accept((Throwable)throwable, this.stanza);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivedByServer() {
        Consumer<S> consumer;
        SendTask sendTask = this;
        synchronized (sendTask) {
            this.receivedByServer = true;
            consumer = this.onAcknowledge;
        }
        if (consumer != null) {
            consumer.accept(this.stanza);
        }
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.sendFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.sendFuture.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.sendFuture.isDone();
    }

    @Override
    public final Void get() throws InterruptedException, ExecutionException {
        return this.sendFuture.get();
    }

    @Override
    public final Void get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sendFuture.get(timeout, timeUnit);
    }
}

