/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.bind.model.Bind;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.session.AuthenticationManager;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.SendTask;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.model.Session;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientMessage;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.im.roster.RosterManager;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class XmppClient
extends XmppSession {
    private static final Logger logger = Logger.getLogger(XmppClient.class.getName());
    private final AuthenticationManager authenticationManager = new AuthenticationManager(this);
    private volatile Jid connectedResource;
    private volatile String resource;
    private volatile String lastAuthorizationId;
    private volatile Collection<String> lastMechanisms;
    private volatile CallbackHandler lastCallbackHandler;
    private volatile boolean anonymous;

    @Deprecated
    public XmppClient(String xmppServiceDomain, ConnectionConfiguration ... connectionConfigurations) {
        this(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    @Deprecated
    public XmppClient(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        super(xmppServiceDomain, configuration, connectionConfigurations);
        this.streamFeaturesManager.addFeatureNegotiator(this.authenticationManager);
        this.streamFeaturesManager.addFeatureNegotiator(new StreamFeatureNegotiator(this, Bind.class){

            @Override
            public StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
                return StreamFeatureNegotiator.Status.INCOMPLETE;
            }

            @Override
            public boolean canProcess(Object element) {
                return false;
            }
        });
    }

    public static XmppClient create(String xmppServiceDomain, ConnectionConfiguration ... connectionConfigurations) {
        return XmppClient.create(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    public static XmppClient create(String xmppServiceDomain, XmppSessionConfiguration configuration, ConnectionConfiguration ... connectionConfigurations) {
        XmppClient xmppClient = new XmppClient(xmppServiceDomain, configuration, connectionConfigurations);
        XmppClient.notifyCreationListeners(xmppClient);
        return xmppClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.preConnect();
        if (this.checkConnected()) {
            return;
        }
        try {
            this.updateStatus(XmppSession.Status.CONNECTING);
            XmppClient xmppClient = this;
            synchronized (xmppClient) {
                if (this.checkConnected()) {
                    return;
                }
                this.exception = null;
                this.tryConnect(from, "jabber:client", this::setXmppServiceDomain);
                logger.fine("Negotiating stream, waiting until SASL is ready to be negotiated.");
                try {
                    this.streamFeaturesManager.awaitNegotiation(Mechanisms.class, Duration.ofSeconds(10L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                logger.fine("Stream negotiated until SASL, now ready to login.");
            }
            this.updateStatus(XmppSession.Status.CONNECTING, XmppSession.Status.CONNECTED);
            if (this.wasLoggedIn) {
                logger.fine("Was already logged in. Re-login automatically with known credentials.");
                this.login(this.lastMechanisms, this.lastAuthorizationId, this.lastCallbackHandler, this.resource);
            }
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    public final byte[] login(String user, String password) throws XmppException {
        return this.login(user, password, null);
    }

    public final byte[] login(String user, String password, String resource) throws XmppException {
        return this.login(null, user, password, resource);
    }

    public final byte[] login(String authorizationId, String user, String password, String resource) throws XmppException {
        Objects.requireNonNull(user, "user must not be null.");
        Objects.requireNonNull(password, "password must not be null.");
        return this.login(authorizationId, (Callback[] callbacks) -> Arrays.stream(callbacks).forEach(callback -> {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(user);
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(password.toCharArray());
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(((RealmCallback)callback).getDefaultText());
            }
        }), resource);
    }

    public final byte[] login(String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        return this.login(this.configuration.getAuthenticationMechanisms(), authorizationId, callbackHandler, resource);
    }

    public final byte[] loginAnonymously() throws XmppException {
        byte[] successData = this.login(Collections.singleton("ANONYMOUS"), null, null, null);
        this.anonymous = true;
        return successData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] login(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        if (this.checkAuthenticated()) {
            return this.authenticationManager.getSuccessData();
        }
        XmppSession.Status previousStatus = this.preLogin();
        this.updateStatus(XmppSession.Status.AUTHENTICATING);
        XmppClient xmppClient = this;
        synchronized (xmppClient) {
            if (this.checkAuthenticated()) {
                return this.authenticationManager.getSuccessData();
            }
            this.lastMechanisms = mechanisms;
            this.lastAuthorizationId = authorizationId;
            this.lastCallbackHandler = callbackHandler;
            try {
                Presence initialPresence;
                PresenceManager presenceManager;
                logger.fine("Starting SASL negotiation (authentication).");
                if (callbackHandler == null) {
                    this.authenticationManager.startAuthentication(mechanisms, null, null);
                } else {
                    this.authenticationManager.startAuthentication(mechanisms, authorizationId, callbackHandler);
                }
                this.streamFeaturesManager.awaitNegotiation(Bind.class, this.configuration.getDefaultResponseTimeout());
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                StreamManager streamManager = this.getManager(StreamManager.class);
                if (streamManager.resume()) {
                    this.updateStatus(XmppSession.Status.AUTHENTICATED);
                    ArrayDeque<Stanza> toBeResent = new ArrayDeque<Stanza>(this.getUnacknowledgedStanzas());
                    this.getUnacknowledgedStanzas().clear();
                    for (Stanza stanza : toBeResent) {
                        this.send((StreamElement)stanza);
                    }
                    return this.authenticationManager.getSuccessData();
                }
                this.bindResource(resource);
                this.streamFeaturesManager.completeNegotiation(this.configuration.getDefaultResponseTimeout());
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                logger.fine("Stream negotiation completed successfully.");
                RosterManager rosterManager = this.getManager(RosterManager.class);
                if (callbackHandler != null && rosterManager.isEnabled() && rosterManager.isRetrieveRosterOnLogin()) {
                    logger.fine("Retrieving roster on login (as per configuration).");
                    rosterManager.requestRoster();
                }
                if ((presenceManager = this.getManager(PresenceManager.class)).getLastSentPresence() != null) {
                    presenceManager.getLastSentPresences().forEach(presence -> {
                        presence.getExtensions().clear();
                        this.send((StreamElement)presence);
                    });
                } else if (this.configuration.getInitialPresence() != null && (initialPresence = this.configuration.getInitialPresence().get()) != null) {
                    this.send((StreamElement)initialPresence);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.updateStatus(previousStatus, e);
                XmppClient.throwAsXmppExceptionIfNotNull(e);
            }
            catch (Throwable e) {
                this.updateStatus(previousStatus, e);
                XmppClient.throwAsXmppExceptionIfNotNull(e);
            }
            logger.fine("Login successful.");
            this.afterLogin();
            return this.authenticationManager.getSuccessData();
        }
    }

    private void bindResource(String resource) throws XmppException {
        this.resource = resource;
        logger.log(Level.FINE, "Negotiating resource binding, resource: {0}.", resource);
        IQ result = (IQ)this.query(IQ.set((Object)new Bind(this.resource))).getResult();
        Bind bindResult = (Bind)result.getExtension(Bind.class);
        this.connectedResource = bindResult.getJid();
        logger.log(Level.FINE, "Resource binding completed, connected resource: {0}.", this.connectedResource);
        Session session = (Session)this.streamFeaturesManager.getFeatures().get(Session.class);
        if (session != null && session.isMandatory()) {
            logger.fine("Establishing session.");
            this.query(IQ.set((Object)new Session()));
        }
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
    }

    @Override
    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public final Future<Void> send(StreamElement element) {
        Object e = element instanceof Message ? ClientMessage.from((Message)((Message)element)) : (element instanceof Presence ? ClientPresence.from((Presence)((Presence)element)) : (element instanceof IQ ? ClientIQ.from((IQ)((IQ)element)) : element));
        return super.send((StreamElement)e);
    }

    @Override
    public final SendTask<IQ> sendIQ(IQ iq) {
        return this.trackAndSend(ClientIQ.from((IQ)iq));
    }

    @Override
    public final SendTask<Message> sendMessage(Message message) {
        return this.trackAndSend(ClientMessage.from((Message)message));
    }

    @Override
    public final SendTask<Presence> sendPresence(Presence presence) {
        return this.trackAndSend(ClientPresence.from((Presence)presence));
    }

    public final AsyncResult<Boolean> isSupported(String feature, Jid jid) {
        return this.getManager(EntityCapabilitiesManager.class).isSupported(feature, jid);
    }
}

