/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class StreamFeaturesManager
extends Manager {
    private static final EnumSet<StreamFeatureNegotiator.Status> NEGOTIATION_COMPLETED = EnumSet.of(StreamFeatureNegotiator.Status.SUCCESS, StreamFeatureNegotiator.Status.IGNORE);
    private final Lock lock = new ReentrantLock();
    private final Map<Class<? extends StreamFeature>, Condition> featureNegotiationStartedConditions = new ConcurrentHashMap<Class<? extends StreamFeature>, Condition>();
    private final HashMap<Class<? extends StreamFeature>, StreamFeature> advertisedFeatures = new HashMap();
    private final Queue<StreamFeature> featuresToNegotiate = new ArrayDeque<StreamFeature>();
    private final Set<Class<? extends StreamFeature>> negotiatingFeatures = new HashSet<Class<? extends StreamFeature>>();
    private final Set<StreamFeatureNegotiator> streamFeatureNegotiators = new CopyOnWriteArraySet<StreamFeatureNegotiator>();
    private final Condition negotiationCompleted = this.lock.newCondition();

    private StreamFeaturesManager(XmppSession xmppSession) {
        super(xmppSession, false);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case CONNECTING: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featureNegotiationStartedConditions.clear();
                        this.advertisedFeatures.clear();
                        this.negotiatingFeatures.clear();
                        break;
                    }
                }
                case CLOSED: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featureNegotiationStartedConditions.clear();
                        this.advertisedFeatures.clear();
                        this.featuresToNegotiate.clear();
                        this.negotiatingFeatures.clear();
                        this.streamFeatureNegotiators.clear();
                        break;
                    }
                }
            }
        });
    }

    public final Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return Collections.unmodifiableMap((HashMap)this.advertisedFeatures.clone());
    }

    public final void addFeatureNegotiator(StreamFeatureNegotiator streamFeatureNegotiator) {
        this.streamFeatureNegotiators.add(streamFeatureNegotiator);
    }

    public final synchronized void processFeatures(StreamFeatures featuresElement) throws StreamNegotiationException {
        List featureList = featuresElement.getFeatures();
        this.featuresToNegotiate.clear();
        featureList.stream().filter(feature -> feature instanceof StreamFeature).sorted().forEach(feature -> {
            StreamFeature f = (StreamFeature)feature;
            this.advertisedFeatures.put(f.getClass(), f);
            this.featuresToNegotiate.add(f);
        });
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        this.negotiateNextFeature();
    }

    public final synchronized boolean processElement(Object element) throws StreamNegotiationException {
        for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
            if (streamFeatureNegotiator.getFeatureClass() != element.getClass() && !streamFeatureNegotiator.canProcess(element)) continue;
            StreamFeatureNegotiator.Status status = streamFeatureNegotiator.processNegotiation(element);
            this.negotiatingFeatures.add(streamFeatureNegotiator.getFeatureClass());
            if (!NEGOTIATION_COMPLETED.contains((Object)status)) continue;
            if (status == StreamFeatureNegotiator.Status.SUCCESS && streamFeatureNegotiator.needsRestart()) {
                return true;
            }
            this.negotiateNextFeature();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean negotiateNextFeature() throws StreamNegotiationException {
        StreamFeature advertisedFeature = this.featuresToNegotiate.poll();
        if (advertisedFeature != null) {
            Class<?> featureClass = advertisedFeature.getClass();
            if (this.negotiatingFeatures.add(featureClass)) {
                Condition condition;
                StreamFeatureNegotiator.Status negotiationStatus = StreamFeatureNegotiator.Status.IGNORE;
                for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
                    if (streamFeatureNegotiator.getFeatureClass() != advertisedFeature.getClass()) continue;
                    negotiationStatus = streamFeatureNegotiator.processNegotiation(advertisedFeature);
                    break;
                }
                if ((condition = this.featureNegotiationStartedConditions.remove(featureClass)) != null) {
                    this.lock.lock();
                    try {
                        condition.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if (negotiationStatus == StreamFeatureNegotiator.Status.INCOMPLETE) {
                    return true;
                }
            }
            return this.negotiateNextFeature();
        }
        this.lock.lock();
        try {
            this.negotiationCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitNegotiation(Class<? extends StreamFeature> streamFeature, Duration timeout) throws InterruptedException, NoResponseException {
        StreamFeaturesManager streamFeaturesManager = this;
        synchronized (streamFeaturesManager) {
            if (this.negotiatingFeatures.contains(streamFeature) || this.featureNegotiationStartedConditions.containsKey(streamFeature)) {
                return;
            }
        }
        Condition condition = this.lock.newCondition();
        this.featureNegotiationStartedConditions.put(streamFeature, condition);
        this.lock.lock();
        try {
            if (!condition.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("No response while waiting on feature: " + streamFeature.getSimpleName());
            }
        }
        catch (InterruptedException e) {
            this.featureNegotiationStartedConditions.remove(streamFeature);
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void completeNegotiation(Duration timeout) throws InterruptedException, NoResponseException, StreamNegotiationException {
        if (!this.negotiateNextFeature()) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.negotiationCompleted.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("No response while waiting during stream feature negotiation.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancelNegotiation() {
        for (Condition condition : this.featureNegotiationStartedConditions.values()) {
            this.lock.lock();
            try {
                condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.featureNegotiationStartedConditions.clear();
    }
}

