/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

public final class CompressionManager
extends StreamFeatureNegotiator {
    @Deprecated
    public static final CompressionMethod ZLIB = CompressionMethod.ZLIB;
    @Deprecated
    public static final CompressionMethod GZIP = CompressionMethod.GZIP;
    @Deprecated
    public static final CompressionMethod DEFLATE = CompressionMethod.DEFLATE;
    private static final Logger logger = Logger.getLogger(CompressionManager.class.getName());
    private final List<CompressionMethod> compressionMethods = new CopyOnWriteArrayList<CompressionMethod>();
    private CompressionMethod negotiatedCompressionMethod;

    private CompressionManager(XmppSession xmppSession) {
        super(xmppSession, CompressionFeature.class);
    }

    @Override
    public final StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
        if (this.compressionMethods.isEmpty()) {
            return StreamFeatureNegotiator.Status.IGNORE;
        }
        if (element instanceof CompressionFeature) {
            List advertisedCompressionMethods = ((CompressionFeature)element).getMethods();
            LinkedHashMap<String, CompressionMethod> clientMethods = new LinkedHashMap<String, CompressionMethod>();
            for (CompressionMethod compressionMethod : this.compressionMethods) {
                clientMethods.put(compressionMethod.getName(), compressionMethod);
            }
            clientMethods.keySet().retainAll(advertisedCompressionMethods);
            if (!clientMethods.isEmpty()) {
                CompressionMethod compressionMethod = (CompressionMethod)clientMethods.values().iterator().next();
                this.xmppSession.send((StreamElement)new StreamCompression.Compress(compressionMethod.getName()));
                this.negotiatedCompressionMethod = compressionMethod;
                return StreamFeatureNegotiator.Status.INCOMPLETE;
            }
            return StreamFeatureNegotiator.Status.IGNORE;
        }
        if (element == StreamCompression.COMPRESSED) {
            this.notifyFeatureNegotiated();
            logger.fine("Stream is now compressed.");
            return StreamFeatureNegotiator.Status.SUCCESS;
        }
        if (element instanceof StreamCompression.Failure) {
            this.negotiatedCompressionMethod = null;
            logger.warning("Failure during compression negotiation: " + ((StreamCompression.Failure)element).getCondition());
            return StreamFeatureNegotiator.Status.IGNORE;
        }
        return StreamFeatureNegotiator.Status.IGNORE;
    }

    @Override
    public final boolean needsRestart() {
        return true;
    }

    @Override
    public final boolean canProcess(Object element) {
        return element instanceof StreamCompression;
    }

    public final CompressionMethod getNegotiatedCompressionMethod() {
        return this.negotiatedCompressionMethod;
    }

    public final List<CompressionMethod> getConfiguredCompressionMethods() {
        return this.compressionMethods;
    }
}

