/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.httpbind.BoshConnection;

public final class BoshConnectionConfiguration
extends ConnectionConfiguration {
    private static volatile BoshConnectionConfiguration defaultConfiguration;
    private final int wait;
    private final String path;
    private final String route;
    private final boolean useKeySequence;

    private BoshConnectionConfiguration(Builder builder) {
        super(builder);
        this.wait = builder.wait;
        this.path = builder.path;
        this.route = builder.route;
        this.useKeySequence = builder.useKeySequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BoshConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = BoshConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(BoshConnectionConfiguration configuration) {
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Connection createConnection(XmppSession xmppSession) {
        return new BoshConnection(xmppSession, this);
    }

    public final int getWait() {
        return this.wait;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getRoute() {
        return this.route;
    }

    public final boolean isUseKeySequence() {
        return this.useKeySequence;
    }

    @Override
    public final String toString() {
        return "BOSH connection configuration: " + (this.isSecure() ? "https" : "http") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder> {
        private int wait;
        private String path;
        private String route;
        private boolean useKeySequence;

        private Builder() {
            this.wait(60);
            this.path("/http-bind/");
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder wait(int wait) {
            this.wait = wait;
            return this;
        }

        public Builder route(String route) {
            this.route = route;
            return this;
        }

        public Builder useKeySequence(boolean useKeySequence) {
            this.useKeySequence = useKeySequence;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoshConnectionConfiguration build() {
            return new BoshConnectionConfiguration(this);
        }
    }
}

