/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.sm.RequestStrategies;
import rocks.xmpp.extensions.sm.model.StreamManagement;

public final class StreamManager
extends StreamFeatureNegotiator {
    private static final long MAX_H = 0xFFFFFFFFL;
    private final Lock lock = new ReentrantLock();
    private final Condition resumed = this.lock.newCondition();
    long inboundCount = 0L;
    private long acknowledgedStanzaCount = 0L;
    private boolean enabledByClient;
    private StreamManagement.Enabled enabled;
    private Predicate<Stanza> requestStrategy = RequestStrategies.forEachMessageOrEveryXStanzas(3);
    private boolean couldResume;

    private StreamManager(XmppSession xmppSession) {
        super(xmppSession, StreamManagement.class);
    }

    static long diff(long h, long acknowledgedCount) {
        return h - acknowledgedCount & 0xFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
        if (!this.isEnabled()) {
            return StreamFeatureNegotiator.Status.IGNORE;
        }
        StreamFeatureNegotiator.Status status = StreamFeatureNegotiator.Status.INCOMPLETE;
        if (element instanceof StreamManagement) {
            StreamManager streamManager = this;
            synchronized (streamManager) {
                this.acknowledgedStanzaCount = 0L;
                this.enabledByClient = true;
            }
            this.xmppSession.send((StreamElement)new StreamManagement.Enable(Boolean.valueOf(true)));
        } else {
            if (element instanceof StreamManagement.Enabled) {
                StreamManager streamManager = this;
                synchronized (streamManager) {
                    this.inboundCount = 0L;
                    this.enabled = (StreamManagement.Enabled)element;
                }
                return StreamFeatureNegotiator.Status.SUCCESS;
            }
            if (element instanceof StreamManagement.Failed) {
                this.releaseLock();
            } else {
                if (element instanceof StreamManagement.Request) {
                    StreamManager streamManager = this;
                    synchronized (streamManager) {
                        this.xmppSession.send((StreamElement)new StreamManagement.Answer(this.inboundCount));
                    }
                }
                if (element instanceof StreamManagement.Answer) {
                    StreamManagement.Answer answer = (StreamManagement.Answer)element;
                    this.markAcknowledged(answer.getLastHandledStanza());
                } else if (element instanceof StreamManagement.Resumed) {
                    StreamManagement.Resumed resumed = (StreamManagement.Resumed)element;
                    this.markAcknowledged(resumed.getLastHandledStanza());
                    StreamManager streamManager = this;
                    synchronized (streamManager) {
                        this.couldResume = true;
                    }
                    this.releaseLock();
                    return StreamFeatureNegotiator.Status.SUCCESS;
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAcknowledged(Long h) {
        if (h != null) {
            long x;
            StreamManager streamManager = this;
            synchronized (streamManager) {
                x = StreamManager.diff(h, this.acknowledgedStanzaCount);
                this.acknowledgedStanzaCount = h;
            }
            for (long i = 0L; i < x; ++i) {
                this.xmppSession.markAcknowledged(this.xmppSession.getUnacknowledgedStanzas().poll());
            }
        }
    }

    @Override
    public final boolean canProcess(Object element) {
        return element instanceof StreamManagement.Request || element instanceof StreamManagement.Answer || element instanceof StreamManagement.Enabled || element instanceof StreamManagement.Failed || element instanceof StreamManagement.Resumed;
    }

    public final synchronized void incrementInboundStanzaCount() {
        ++this.inboundCount;
        this.inboundCount &= 0xFFFFFFFFL;
    }

    public synchronized void markUnacknowledged(Stanza stanza) {
        if (this.enabledByClient) {
            this.xmppSession.getUnacknowledgedStanzas().offer(stanza);
        }
    }

    public final synchronized Predicate<Stanza> getRequestStrategy() {
        return this.requestStrategy;
    }

    public final synchronized void setRequestStrategy(Predicate<Stanza> requestStrategy) {
        this.requestStrategy = requestStrategy;
    }

    public final synchronized boolean isActive() {
        return this.enabled != null;
    }

    private void releaseLock() {
        this.lock.lock();
        try {
            this.resumed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final synchronized boolean isResumable() {
        return this.enabled != null && this.enabled.isResume();
    }

    public final synchronized String getStreamManagementId() {
        return this.enabled != null ? this.enabled.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() throws InterruptedException, NoResponseException {
        if (!this.isResumable()) {
            return false;
        }
        StreamManager streamManager = this;
        synchronized (streamManager) {
            this.couldResume = false;
            this.xmppSession.send((StreamElement)new StreamManagement.Resume(this.inboundCount, this.getStreamManagementId()));
        }
        this.lock.lock();
        try {
            if (!this.resumed.await(this.xmppSession.getConfiguration().getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("Stream could not be resumed in time.");
            }
        }
        finally {
            this.lock.unlock();
        }
        streamManager = this;
        synchronized (streamManager) {
            return this.couldResume;
        }
    }
}

