/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.nio.ByteBuffer;
import rocks.xmpp.dns.ResourceRecord;

public final class SrvRecord
implements Comparable<SrvRecord> {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;

    SrvRecord(ByteBuffer data) {
        this.priority = data.getShort() & 0xFFFF;
        this.weight = data.getShort() & 0xFFFF;
        this.port = data.getShort() & 0xFFFF;
        this.target = ResourceRecord.parse(data);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getTarget() {
        return this.target;
    }

    @Override
    public final int compareTo(SrvRecord o) {
        if (o == null) {
            return -1;
        }
        int result = Integer.compare(this.priority, o.priority);
        if (result == 0) {
            return Integer.compare(this.weight, o.weight);
        }
        return result;
    }

    public final String toString() {
        return "SRV " + this.priority + ' ' + this.weight + ' ' + this.port + ' ' + this.target;
    }
}

