/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.TcpConnection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.XmppUtils;

final class XmppStreamReader {
    private static final QName STREAM_ID = new QName("id");
    private static final QName FROM = new QName("from");
    private final TcpConnection connection;
    private final XmppSession xmppSession;
    private final ExecutorService executorService;
    private final XmppDebugger debugger;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final Consumer<Jid> onStreamOpened;
    private final String namespace;

    XmppStreamReader(String namespace, TcpConnection connection, XmppSession xmppSession, Consumer<Jid> onStreamOpened) {
        this.connection = connection;
        this.xmppSession = xmppSession;
        this.debugger = xmppSession.getDebugger();
        this.marshaller = xmppSession.createMarshaller();
        this.unmarshaller = xmppSession.createUnmarshaller();
        this.executorService = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Reader Thread"));
        this.onStreamOpened = onStreamOpened;
        this.namespace = namespace;
    }

    synchronized void startReading(InputStream inputStream) {
        if (!this.executorService.isShutdown()) {
            this.executorService.execute(() -> {
                boolean doRestart = false;
                XMLEventReader xmlEventReader = null;
                try {
                    XMLEvent xmlEvent;
                    InputStream xmppInputStream = null;
                    if (this.debugger != null) {
                        xmppInputStream = this.debugger.createInputStream(inputStream);
                    }
                    if (xmppInputStream == null) {
                        xmppInputStream = inputStream;
                    }
                    XMLEvent startDocument = null;
                    xmlEventReader = this.xmppSession.getConfiguration().getXmlInputFactory().createXMLEventReader(xmppInputStream, "UTF-8");
                    StreamErrorException streamError = null;
                    while (!doRestart && (xmlEvent = xmlEventReader.peek()) != null) {
                        StringWriter stringWriter = null;
                        if (this.debugger != null) {
                            stringWriter = new StringWriter();
                            if (xmlEvent.isStartDocument()) {
                                startDocument = xmlEvent;
                            }
                        }
                        if (xmlEvent.isStartElement()) {
                            StartElement startElement = xmlEvent.asStartElement();
                            if ("stream".equals(startElement.getName().getLocalPart()) && "http://etherx.jabber.org/streams".equals(startElement.getName().getNamespaceURI())) {
                                Attribute idAttribute = startElement.getAttributeByName(STREAM_ID);
                                if (idAttribute != null) {
                                    TcpConnection tcpConnection = this.connection;
                                    synchronized (tcpConnection) {
                                        this.connection.streamId = idAttribute.getValue();
                                    }
                                }
                                if (this.onStreamOpened != null) {
                                    Attribute fromAttribute = startElement.getAttributeByName(FROM);
                                    this.onStreamOpened.accept(fromAttribute != null ? Jid.of((CharSequence)fromAttribute.getValue()) : null);
                                }
                                if (this.debugger != null) {
                                    XMLEventWriter writer = this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLEventWriter(stringWriter);
                                    writer.add(startDocument);
                                    writer.add(xmlEvent);
                                    writer.flush();
                                    this.debugger.readStanza(stringWriter.append('>').toString(), null);
                                    writer.close();
                                }
                                xmlEventReader.nextEvent();
                            } else {
                                Object object = this.unmarshaller.unmarshal(xmlEventReader);
                                if (this.debugger != null) {
                                    XMLStreamWriter xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(stringWriter), (String)this.namespace);
                                    this.marshaller.marshal(object, xmlStreamWriter);
                                    xmlStreamWriter.flush();
                                    this.debugger.readStanza(stringWriter.toString(), object);
                                }
                                try {
                                    doRestart = this.xmppSession.handleElement(object);
                                }
                                catch (StreamErrorException e) {
                                    streamError = e;
                                }
                                catch (XmppException e) {
                                    this.xmppSession.notifyException(e);
                                }
                            }
                        } else {
                            xmlEventReader.nextEvent();
                        }
                        if (!xmlEvent.isEndElement() || this.debugger == null) continue;
                        QName qName = xmlEvent.asEndElement().getName();
                        this.debugger.readStanza("</" + qName.getPrefix() + ':' + qName.getLocalPart() + '>', null);
                    }
                    xmlEventReader.close();
                    if (streamError != null) {
                        throw streamError;
                    }
                    if (!doRestart && this.xmppSession.getStatus() != XmppSession.Status.CLOSING) {
                        throw new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "Stream closed by server", Locale.ENGLISH, null));
                    }
                }
                catch (Exception e) {
                    XmppStreamReader xmppStreamReader = this;
                    synchronized (xmppStreamReader) {
                        if (!this.executorService.isShutdown()) {
                            this.executorService.shutdown();
                        }
                    }
                    this.xmppSession.notifyException(e);
                }
                finally {
                    if (xmlEventReader != null) {
                        try {
                            xmlEventReader.close();
                        }
                        catch (XMLStreamException e) {
                            this.xmppSession.notifyException(e);
                        }
                    }
                    if (doRestart) {
                        this.connection.restartStream();
                    }
                }
            });
        }
    }

    synchronized void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

