/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class StreamFeaturesManager
extends Manager {
    private static final EnumSet<StreamFeatureNegotiator.Status> NEGOTIATION_COMPLETED = EnumSet.of(StreamFeatureNegotiator.Status.SUCCESS, StreamFeatureNegotiator.Status.IGNORE);
    private final Map<Class<? extends StreamFeature>, CompletableFuture<Void>> featureNegotiationStartedFutures = new ConcurrentHashMap<Class<? extends StreamFeature>, CompletableFuture<Void>>();
    private final HashMap<Class<? extends StreamFeature>, StreamFeature> advertisedFeatures = new HashMap();
    private final Queue<StreamFeature> featuresToNegotiate = new ArrayDeque<StreamFeature>();
    private final Set<StreamFeatureNegotiator> streamFeatureNegotiators = new CopyOnWriteArraySet<StreamFeatureNegotiator>();
    private CompletableFuture<Void> negotiationCompleted;

    private StreamFeaturesManager(XmppSession xmppSession) {
        super(xmppSession, false);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case CONNECTING: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featureNegotiationStartedFutures.clear();
                        this.advertisedFeatures.clear();
                        break;
                    }
                }
                case CLOSED: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featureNegotiationStartedFutures.clear();
                        this.advertisedFeatures.clear();
                        this.featuresToNegotiate.clear();
                        this.streamFeatureNegotiators.clear();
                        break;
                    }
                }
            }
        });
    }

    public final Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return Collections.unmodifiableMap((HashMap)this.advertisedFeatures.clone());
    }

    public final void addFeatureNegotiator(StreamFeatureNegotiator streamFeatureNegotiator) {
        this.streamFeatureNegotiators.add(streamFeatureNegotiator);
    }

    public final void removeFeatureNegotiator(StreamFeatureNegotiator streamFeatureNegotiator) {
        this.streamFeatureNegotiators.remove(streamFeatureNegotiator);
    }

    public final synchronized void processFeatures(StreamFeatures featuresElement) throws StreamNegotiationException {
        List featureList = featuresElement.getFeatures();
        this.featuresToNegotiate.clear();
        featureList.stream().filter(feature -> feature instanceof StreamFeature).sorted().forEach(feature -> {
            StreamFeature f = (StreamFeature)feature;
            this.advertisedFeatures.put(f.getClass(), f);
            this.featuresToNegotiate.add(f);
        });
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        this.negotiationCompleted = new CompletableFuture();
        this.negotiateNextFeature();
    }

    public final synchronized boolean processElement(Object element) throws StreamNegotiationException {
        for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
            if (streamFeatureNegotiator.getFeatureClass() != element.getClass() && !streamFeatureNegotiator.canProcess(element)) continue;
            CompletableFuture streamFuture = this.featureNegotiationStartedFutures.computeIfAbsent(streamFeatureNegotiator.getFeatureClass(), k -> new CompletableFuture());
            StreamFeatureNegotiator.Status status = streamFeatureNegotiator.processNegotiation(element);
            if (NEGOTIATION_COMPLETED.contains((Object)status)) {
                streamFuture.complete(null);
                if (status == StreamFeatureNegotiator.Status.SUCCESS && streamFeatureNegotiator.needsRestart()) {
                    return true;
                }
                this.negotiateNextFeature();
            }
            return false;
        }
        return false;
    }

    private synchronized boolean negotiateNextFeature() throws StreamNegotiationException {
        StreamFeature advertisedFeature = this.featuresToNegotiate.poll();
        if (advertisedFeature != null) {
            Class<?> featureClass = advertisedFeature.getClass();
            CompletableFuture streamFuture = this.featureNegotiationStartedFutures.computeIfAbsent(featureClass, k -> new CompletableFuture());
            if (!streamFuture.isDone()) {
                StreamFeatureNegotiator.Status negotiationStatus = StreamFeatureNegotiator.Status.IGNORE;
                for (StreamFeatureNegotiator streamFeatureNegotiator : this.streamFeatureNegotiators) {
                    if (streamFeatureNegotiator.getFeatureClass() != advertisedFeature.getClass()) continue;
                    negotiationStatus = streamFeatureNegotiator.processNegotiation(advertisedFeature);
                    break;
                }
                streamFuture.complete(null);
                if (negotiationStatus == StreamFeatureNegotiator.Status.INCOMPLETE) {
                    return true;
                }
            }
            return this.negotiateNextFeature();
        }
        this.featureNegotiationStartedFutures.clear();
        this.negotiationCompleted.complete(null);
        return false;
    }

    public final Future<Void> awaitNegotiation(Class<? extends StreamFeature> streamFeature) {
        return this.featureNegotiationStartedFutures.computeIfAbsent(streamFeature, k -> new CompletableFuture());
    }

    public final synchronized Future<Void> completeNegotiation() throws StreamNegotiationException {
        this.negotiateNextFeature();
        return this.negotiationCompleted;
    }

    public void cancelNegotiation() {
        for (Future future : this.featureNegotiationStartedFutures.values()) {
            future.cancel(false);
        }
        this.featureNegotiationStartedFutures.clear();
    }
}

