/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public interface CompressionMethod {
    public static final CompressionMethod ZLIB = new CompressionMethod(){

        @Override
        public String getName() {
            return "zlib";
        }

        @Override
        public InputStream decompress(InputStream inputStream) throws IOException {
            return new InflaterInputStream(inputStream);
        }

        @Override
        public OutputStream compress(OutputStream outputStream) throws IOException {
            return new DeflaterOutputStream(outputStream, true);
        }
    };
    public static final CompressionMethod GZIP = new CompressionMethod(){

        @Override
        public String getName() {
            return "gzip";
        }

        @Override
        public InputStream decompress(InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream, 65536);
        }

        @Override
        public OutputStream compress(OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    };
    public static final CompressionMethod DEFLATE = new CompressionMethod(){

        @Override
        public String getName() {
            return "deflate";
        }

        @Override
        public InputStream decompress(InputStream inputStream) throws IOException {
            return new InflaterInputStream(inputStream, new Inflater(true));
        }

        @Override
        public OutputStream compress(OutputStream outputStream) throws IOException {
            return new DeflaterOutputStream(outputStream, new Deflater(-1, true));
        }
    };

    public String getName();

    public InputStream decompress(InputStream var1) throws IOException;

    public OutputStream compress(OutputStream var1) throws IOException;
}

