/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.MockServer;
import rocks.xmpp.core.SameThreadExecutorService;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;

public final class TestXmppSession
extends XmppSession {
    private final Jid connectedResource;

    public TestXmppSession() {
        this(Jid.of((CharSequence)"test@domain/resource"), new MockServer());
    }

    public TestXmppSession(Jid jid, MockServer mockServer) {
        this(jid, mockServer, XmppSessionConfiguration.getDefault());
    }

    public TestXmppSession(Jid jid, MockServer mockServer, XmppSessionConfiguration configuration) {
        super(null, configuration, new ConnectionConfiguration[0]);
        this.connectedResource = jid;
        this.addSendSucceededListener(element -> {
            if (mockServer != null && element instanceof Stanza) {
                ((Stanza)element).setFrom(this.connectedResource);
                mockServer.receive((Stanza)element);
            }
        });
        this.activeConnection = new Connection(null, (ConnectionConfiguration)TcpConnectionConfiguration.builder().build()){

            protected void restartStream() {
            }

            public CompletableFuture<Void> send(StreamElement clientStreamElement) {
                return CompletableFuture.completedFuture(null);
            }

            public void connect(Jid from, String namespace, Consumer<Jid> onConnected) throws IOException {
            }

            public boolean isSecure() {
                return false;
            }

            public String getStreamId() {
                return null;
            }

            public boolean isUsingAcknowledgements() {
                return false;
            }

            public void close() throws IOException {
            }
        };
        this.stanzaListenerExecutor = this.iqHandlerExecutor = new SameThreadExecutorService();
        mockServer.registerConnection(this);
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
    }

    public void connect(Jid from) throws XmppException {
    }

    public Jid getConnectedResource() {
        return this.connectedResource;
    }
}

