/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import rocks.xmpp.core.session.Manager;

public final class Extension {
    private final String namespace;
    private final Class<? extends Manager> manager;
    private final Set<Class<?>> classes;
    private final Set<String> features;
    private final boolean enabled;

    private Extension(String namespace, Class<? extends Manager> manager, Set<String> features, boolean enabled, Class<?> ... classes) {
        this.namespace = namespace;
        this.manager = manager;
        this.classes = new HashSet(Arrays.asList(classes));
        this.features = features;
        this.enabled = enabled;
    }

    public static Extension of(Class<?> ... classes) {
        if (classes.length == 0) {
            throw new IllegalArgumentException("Classes cannot be empty.");
        }
        for (Class<?> cl : classes) {
            if (!Manager.class.isAssignableFrom(cl)) continue;
            throw new IllegalArgumentException("Manager classes are not allowed to use as JAXB class.");
        }
        return new Extension(null, null, Collections.emptySet(), true, classes);
    }

    public static Extension of(Class<? extends Manager> manager, boolean enabled) {
        return new Extension(null, Objects.requireNonNull(manager), Collections.emptySet(), enabled, new Class[0]);
    }

    public static Extension of(String namespace, boolean enabled, Class<?> ... classes) {
        return new Extension(Objects.requireNonNull(namespace), null, Collections.emptySet(), enabled, classes);
    }

    public static Extension of(String namespace, Class<? extends Manager> manager, boolean enabled, Class<?> ... classes) {
        return new Extension(Objects.requireNonNull(namespace), manager, Collections.emptySet(), enabled, classes);
    }

    public static Extension of(String namespace, Class<? extends Manager> manager, boolean notify, boolean enabled, Class<?> ... classes) {
        return new Extension(Objects.requireNonNull(namespace), manager, notify ? Collections.singleton(namespace + "+notify") : Collections.emptySet(), enabled, classes);
    }

    public static Extension of(String namespace, Class<? extends Manager> manager, Set<String> features, boolean enabled, Class<?> ... classes) {
        return new Extension(namespace, manager, features, enabled, classes);
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final Class<? extends Manager> getManager() {
        return this.manager;
    }

    public final Collection<Class<?>> getClasses() {
        return this.classes;
    }

    public final Collection<String> getFeatures() {
        return this.features;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)o;
        if (this.namespace != null) {
            return this.namespace.equals(other.namespace);
        }
        if (this.manager != null) {
            return this.manager.equals(other.manager);
        }
        return this.classes.equals(other.classes);
    }

    public final int hashCode() {
        if (this.namespace != null) {
            return Objects.hash(this.namespace);
        }
        if (this.manager != null) {
            return Objects.hash(this.manager);
        }
        return Objects.hash(this.classes);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.namespace != null) {
            sb.append(this.namespace);
        }
        if (this.manager != null) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(this.manager.getCanonicalName());
        }
        if (this.namespace != null || this.manager != null) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            if (this.enabled) {
                sb.append("enabled");
            } else {
                sb.append("disabled");
            }
        }
        if (!this.classes.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            StringJoiner sj = new StringJoiner(", ");
            this.classes.stream().map(Class::getCanonicalName).forEach(sj::add);
            sb.append(sj);
        }
        return sb.toString();
    }
}

