/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.session.Extension;
import rocks.xmpp.core.session.Module;
import rocks.xmpp.core.session.ReconnectionStrategy;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.model.Presence;

public final class XmppSessionConfiguration {
    private static final Path DEFAULT_APPLICATION_DATA_PATH;
    private static volatile XmppSessionConfiguration defaultConfiguration;
    private final JAXBContext jaxbContext;
    private final XMLInputFactory xmlInputFactory;
    private final XMLOutputFactory xmlOutputFactory;
    private final Class<? extends XmppDebugger> xmppDebugger;
    private final Duration defaultResponseTimeout;
    private final List<String> authenticationMechanisms;
    private final Path cacheDirectory;
    private final Supplier<Presence> initialPresence;
    private final Set<Extension> extensions;
    private final Locale language;
    private final ReconnectionStrategy reconnectionStrategy;
    private final String nameServer;

    private XmppSessionConfiguration(Builder builder) {
        this.xmppDebugger = builder.xmppDebugger;
        this.defaultResponseTimeout = builder.defaultResponseTimeout;
        this.authenticationMechanisms = builder.authenticationMechanisms;
        this.cacheDirectory = builder.cacheDirectory;
        this.initialPresence = builder.initialPresence;
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.xmlOutputFactory = XMLOutputFactory.newFactory();
        this.language = builder.language != null ? builder.language : Locale.getDefault();
        this.reconnectionStrategy = builder.reconnectionStrategy;
        this.nameServer = builder.nameServer;
        this.extensions = new HashSet<Extension>();
        ServiceLoader<Module> loader = ServiceLoader.load(Module.class);
        for (Module module : loader) {
            this.extensions.addAll(module.getExtensions());
        }
        this.extensions.removeAll(builder.extensions);
        this.extensions.addAll(builder.extensions);
        ArrayDeque classesToBeBound = new ArrayDeque();
        for (Extension extension : this.extensions) {
            classesToBeBound.addAll(extension.getClasses());
        }
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound.toArray(new Class[classesToBeBound.size()]));
        }
        catch (JAXBException jAXBException) {
            throw new DataBindingException((Throwable)jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmppSessionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = XmppSessionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(XmppSessionConfiguration configuration) {
        Class<XmppSessionConfiguration> clazz = XmppSessionConfiguration.class;
        synchronized (XmppSessionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public final Class<? extends XmppDebugger> getDebugger() {
        return this.xmppDebugger;
    }

    public final Duration getDefaultResponseTimeout() {
        return this.defaultResponseTimeout;
    }

    public final List<String> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authenticationMechanisms);
    }

    public final Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public final Supplier<Presence> getInitialPresence() {
        return this.initialPresence;
    }

    public final Locale getLanguage() {
        return this.language;
    }

    public final ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public final String getNameServer() {
        return this.nameServer;
    }

    final Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public final XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public final XMLOutputFactory getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    static {
        Path path;
        String appName = "xmpp.rocks";
        try {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                path = Paths.get(appData, new String[0]);
            } else {
                appData = System.getProperty("user.home");
                path = Paths.get(appData, "Library", "Application Support");
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(appData, new String[0]);
                }
            }
            path = path.resolve(appName);
        }
        catch (Exception e) {
            path = Paths.get(appName, new String[0]);
        }
        DEFAULT_APPLICATION_DATA_PATH = path;
    }

    public static final class Builder {
        private final Collection<Extension> extensions = new ArrayDeque<Extension>();
        private Class<? extends XmppDebugger> xmppDebugger;
        private Duration defaultResponseTimeout;
        private Path cacheDirectory;
        private Supplier<Presence> initialPresence;
        private Locale language;
        private ReconnectionStrategy reconnectionStrategy;
        private String nameServer;
        private List<String> authenticationMechanisms = Arrays.asList("SCRAM-SHA-1", "DIGEST-MD5", "GSSAPI", "CRAM-MD5", "PLAIN", "ANONYMOUS");

        private Builder() {
            this.defaultResponseTimeout(Duration.ofSeconds(5L)).cacheDirectory(DEFAULT_APPLICATION_DATA_PATH).initialPresence(Presence::new);
        }

        public final Builder debugger(Class<? extends XmppDebugger> xmppDebugger) {
            this.xmppDebugger = xmppDebugger;
            return this;
        }

        public final Builder extensions(Extension ... extensions) {
            this.extensions.addAll(Arrays.asList(extensions));
            return this;
        }

        @Deprecated
        public final Builder defaultResponseTimeout(int defaultResponseTimeout) {
            return this.defaultResponseTimeout(Duration.ofMillis(defaultResponseTimeout));
        }

        public final Builder defaultResponseTimeout(Duration defaultResponseTimeout) {
            this.defaultResponseTimeout = Objects.requireNonNull(defaultResponseTimeout);
            return this;
        }

        public final Builder authenticationMechanisms(String ... authenticationMechanisms) {
            this.authenticationMechanisms = Arrays.asList(authenticationMechanisms);
            return this;
        }

        public final Builder cacheDirectory(Path path) {
            if (path != null && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("path is not a directory.");
            }
            this.cacheDirectory = path;
            return this;
        }

        public final Builder initialPresence(Supplier<Presence> presenceSupplier) {
            this.initialPresence = presenceSupplier;
            return this;
        }

        public final Builder language(Locale language) {
            this.language = language;
            return this;
        }

        public final Builder reconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
            this.reconnectionStrategy = reconnectionStrategy;
            return this;
        }

        public final Builder nameServer(String nameServer) {
            this.nameServer = nameServer;
            return this;
        }

        public final XmppSessionConfiguration build() {
            return new XmppSessionConfiguration(this);
        }
    }
}

