/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import rocks.xmpp.dns.Message;
import rocks.xmpp.dns.ResourceRecord;

final class Question {
    private final String domain;
    private final ResourceRecord.Type type;
    private final ResourceRecord.Class clazz;

    Question(String domain, ResourceRecord.Type type, ResourceRecord.Class clazz) {
        this.domain = domain;
        this.type = type;
        this.clazz = clazz;
    }

    Question(ByteBuffer data) {
        this.domain = ResourceRecord.parse(data);
        this.type = ResourceRecord.Type.valueOf(data.getShort() & 0xFFFF);
        this.clazz = ResourceRecord.Class.valueOf(data.getShort() & 0xFFFF);
    }

    final byte[] toByteArray() {
        String asciiDomain = IDN.toASCII(this.domain);
        String[] labels = asciiDomain.split("[.\u3002\uff0e\uff61]");
        byte[] bytes = new byte[]{};
        for (String label : labels) {
            byte[] lbl = label.getBytes(StandardCharsets.US_ASCII);
            byte[] tmpBuffer = bytes;
            bytes = Message.concatArrays(tmpBuffer, Message.concatArrays(new byte[]{(byte)lbl.length}, lbl));
        }
        byte[] value = new byte[]{0, (byte)(this.type.value >> 8), (byte)this.type.value, (byte)(this.clazz.value >> 8), (byte)this.clazz.value};
        return Message.concatArrays(bytes, value);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Question)) {
            return false;
        }
        Question other = (Question)o;
        return Arrays.equals(this.toByteArray(), other.toByteArray());
    }

    public final String toString() {
        return this.domain + ' ' + (Object)((Object)this.type) + ' ' + (Object)((Object)this.clazz);
    }
}

