/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TxtRecord
implements Comparable<TxtRecord> {
    private final String txt;

    TxtRecord(ByteBuffer data, int length) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            int l = data.get() & 0xFF;
            byte[] characterString = new byte[l];
            data.get(characterString);
            sb.append(new String(characterString, StandardCharsets.UTF_8));
            i = (short)(i + (l + 1));
        }
        this.txt = sb.toString();
    }

    public final String getText() {
        return this.txt;
    }

    public final Map<String, String> asAttributes() {
        Matcher matcher = Pattern.compile("(?<!`)=").matcher(this.txt);
        if (matcher.find()) {
            return Collections.singletonMap(this.txt.substring(0, matcher.start()), this.txt.substring(matcher.start() + 1));
        }
        return Collections.emptyMap();
    }

    @Override
    public final int compareTo(TxtRecord o) {
        if (o == null) {
            return -1;
        }
        return this.txt.compareTo(o.txt);
    }

    public final String toString() {
        return "TXT \"" + this.txt + '\"';
    }
}

