/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm;

import java.util.function.Predicate;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Stanza;

public final class RequestStrategies {
    private static final Predicate<Stanza> FOR_EACH_MESSAGE = stanza -> stanza instanceof Message;

    private RequestStrategies() {
    }

    public static Predicate<Stanza> forEveryXStanzas(int x) {
        return new ForEveryXStanzas(x);
    }

    public static Predicate<Stanza> forEachMessage() {
        return FOR_EACH_MESSAGE;
    }

    public static Predicate<Stanza> forEachMessageOrEveryXStanzas(final int x) {
        return new Predicate<Stanza>(){
            private final ForEveryXStanzas forEveryStanza;
            {
                this.forEveryStanza = new ForEveryXStanzas(x);
            }

            @Override
            public final boolean test(Stanza stanza) {
                if (FOR_EACH_MESSAGE.test(stanza)) {
                    this.forEveryStanza.sentStanzas = 0;
                    return true;
                }
                return this.forEveryStanza.test(stanza);
            }
        };
    }

    private static final class ForEveryXStanzas
    implements Predicate<Stanza> {
        private final int x;
        private int sentStanzas;

        private ForEveryXStanzas(int x) {
            this.x = x;
        }

        @Override
        public final boolean test(Stanza stanza) {
            if (++this.sentStanzas == this.x) {
                this.sentStanzas = 0;
                return true;
            }
            return false;
        }
    }
}

