/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.compress.CompressionMethod;

public abstract class ClientConnectionConfiguration
implements ConnectionConfiguration {
    private final String hostname;
    private final int port;
    private final Proxy proxy;
    private final ChannelEncryption channelEncryption;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final int connectTimeout;
    private final List<CompressionMethod> compressionMethods;

    protected ClientConnectionConfiguration(Builder<? extends Builder> builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.proxy = builder.proxy;
        this.channelEncryption = builder.channelEncryption;
        this.sslContext = builder.sslContext;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.connectTimeout = builder.connectTimeout;
        this.compressionMethods = builder.compressionMethods;
    }

    public abstract Connection createConnection(XmppSession var1) throws Exception;

    public final String getHostname() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final Proxy getProxy() {
        return this.proxy;
    }

    public final ChannelEncryption getChannelEncryption() {
        return this.channelEncryption;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final List<CompressionMethod> getCompressionMethods() {
        return this.compressionMethods;
    }

    public String toString() {
        return this.hostname + ':' + this.port;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String hostname;
        protected int port;
        protected Proxy proxy;
        protected ChannelEncryption channelEncryption;
        protected SSLContext sslContext;
        protected HostnameVerifier hostnameVerifier;
        protected int connectTimeout;
        protected List<CompressionMethod> compressionMethods = Collections.emptyList();

        protected Builder() {
        }

        protected abstract T self();

        public final T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public final T port(int port) {
            this.port = port;
            return this.self();
        }

        public final T proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.self();
        }

        @Deprecated
        public final T secure(boolean secure) {
            this.channelEncryption(secure ? ChannelEncryption.REQUIRED : ChannelEncryption.DISABLED);
            return this.self();
        }

        public final T channelEncryption(ChannelEncryption channelEncryption) {
            this.channelEncryption = channelEncryption;
            return this.self();
        }

        public final T sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this.self();
        }

        public final T hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this.self();
        }

        public final T connectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("connectionTimeout cannot be negative.");
            }
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public final T compressionMethods(CompressionMethod ... compressionMethods) {
            this.compressionMethods = Arrays.asList(compressionMethods);
            return this.self();
        }

        public abstract ClientConnectionConfiguration build();
    }
}

