/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.net.client.XmppStreamReader;
import rocks.xmpp.core.net.client.XmppStreamWriter;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.tls.client.StartTlsManager;
import rocks.xmpp.extensions.compress.CompressionManager;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.extensions.sm.model.StreamManagement;

public final class SocketConnection
extends AbstractConnection
implements TcpBinding {
    private static final Logger logger = Logger.getLogger(SocketConnection.class.getName());
    private final StreamFeaturesManager streamFeaturesManager;
    private final StartTlsManager securityManager;
    private final CompressionManager compressionManager;
    private final StreamManager streamManager;
    private final TcpConnectionConfiguration tcpConnectionConfiguration;
    private final XmppSession xmppSession;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private Socket socket;
    private XmppStreamWriter xmppStreamWriter;
    private XmppStreamReader xmppStreamReader;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SessionOpen sessionOpen;

    public SocketConnection(Socket socket, XmppSession xmppSession, TcpConnectionConfiguration configuration) {
        super((ConnectionConfiguration)configuration);
        this.socket = socket;
        try {
            this.outputStream = new BufferedOutputStream(socket.getOutputStream());
            this.inputStream = new BufferedInputStream(socket.getInputStream());
            this.xmppSession = xmppSession;
            this.tcpConnectionConfiguration = configuration;
            this.streamFeaturesManager = xmppSession.getManager(StreamFeaturesManager.class);
            this.streamManager = xmppSession.getManager(StreamManager.class);
            this.securityManager = new StartTlsManager(xmppSession, this, this.tcpConnectionConfiguration.getChannelEncryption());
            this.compressionManager = new CompressionManager(xmppSession, this);
            this.compressionManager.getConfiguredCompressionMethods().clear();
            this.compressionManager.getConfiguredCompressionMethods().addAll(this.tcpConnectionConfiguration.getCompressionMethods());
            this.streamFeaturesManager.addFeatureNegotiator(this.securityManager);
            this.streamFeaturesManager.addFeatureNegotiator(this.compressionManager);
            this.streamFeaturesManager.addFeatureNegotiator(this.streamManager);
            this.streamManager.reset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        OutputStream os;
        InputStream is;
        StreamHeader streamHeader = (StreamHeader)sessionOpen;
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            this.sessionOpen = sessionOpen;
        }
        this.xmppStreamReader = new XmppStreamReader(streamHeader.getContentNamespace(), this, this.xmppSession);
        SocketConnection socketConnection2 = this;
        synchronized (socketConnection2) {
            is = this.inputStream;
        }
        this.xmppStreamReader.startReading(is, arg_0 -> ((SocketConnection)this).openedByPeer(arg_0), () -> ((SocketConnection)this).closedByPeer());
        this.xmppStreamWriter = new XmppStreamWriter(streamHeader.getContentNamespace(), this.streamManager, this.xmppSession);
        this.xmppStreamWriter.initialize(this.tcpConnectionConfiguration.getKeepAliveInterval());
        SocketConnection socketConnection3 = this;
        synchronized (socketConnection3) {
            os = this.outputStream;
        }
        return this.xmppStreamWriter.openStream(os, streamHeader);
    }

    public synchronized boolean isSecure() {
        return this.socket instanceof SSLSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureConnection() throws IOException, CertificateException, NoSuchAlgorithmException {
        SSLSocket sslSocket;
        if (this.isSecure()) {
            return;
        }
        SSLContext sslContext = this.tcpConnectionConfiguration.getSSLContext();
        if (sslContext == null) {
            sslContext = SSLContext.getDefault();
        }
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            this.socket = sslContext.getSocketFactory().createSocket(this.socket, this.xmppSession.getDomain().toString(), this.socket.getPort(), true);
            sslSocket = (SSLSocket)this.socket;
        }
        HostnameVerifier verifier = this.tcpConnectionConfiguration.getHostnameVerifier();
        if (verifier == null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslSocket.setSSLParameters(sslParameters);
        } else {
            sslSocket.startHandshake();
            if (!verifier.verify(this.xmppSession.getDomain().toString(), sslSocket.getSession())) {
                throw new CertificateException("Server failed to authenticate as " + this.xmppSession.getDomain());
            }
        }
        SocketConnection socketConnection2 = this;
        synchronized (socketConnection2) {
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 65536);
        }
        logger.log(Level.FINE, "Connection has been secured via TLS.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressConnection(String method, Runnable onSuccess) throws Exception {
        OutputStream oStream;
        InputStream iStream;
        CompressionMethod compressionMethod = this.compressionManager.getNegotiatedCompressionMethod();
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            iStream = this.inputStream;
            oStream = this.outputStream;
        }
        try {
            iStream = compressionMethod.decompress(iStream);
            oStream = compressionMethod.compress(oStream);
            socketConnection = this;
            synchronized (socketConnection) {
                this.inputStream = iStream;
                this.outputStream = oStream;
            }
        }
        catch (IOException e) {
            this.xmppSession.send((StreamElement)new StreamError(Condition.UNDEFINED_CONDITION, (Object)new StreamCompression.Failure(StreamCompression.Failure.Condition.PROCESSING_FAILED)));
            try {
                this.xmppSession.close();
            }
            catch (XmppException e1) {
                this.xmppSession.notifyException(e1);
            }
            throw new StreamNegotiationException((Throwable)e);
        }
    }

    public final synchronized CompletableFuture<Void> send(StreamElement element) {
        boolean requestStanzaCount = element instanceof Stanza && this.streamManager.isActive() && this.streamManager.getRequestStrategy().test((Stanza)element);
        CompletableFuture<Void> future = this.xmppStreamWriter.write(element, !requestStanzaCount);
        if (requestStanzaCount) {
            return future.thenRun(() -> this.xmppStreamWriter.write((StreamElement)StreamManagement.REQUEST, true));
        }
        return future;
    }

    public final CompletableFuture<Void> write(StreamElement streamElement) {
        return this.xmppStreamWriter.write(streamElement, false);
    }

    public final void flush() {
        this.xmppStreamWriter.flush();
    }

    protected final synchronized void restartStream() {
        this.xmppStreamWriter.openStream(this.outputStream, (StreamHeader)this.sessionOpen);
        this.xmppStreamReader.startReading(this.inputStream, arg_0 -> ((SocketConnection)this).openedByPeer(arg_0), () -> ((SocketConnection)this).closedByPeer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStage<Void> closeStream() {
        XmppStreamReader reader;
        XmppStreamWriter writer;
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            writer = this.xmppStreamWriter;
            reader = this.xmppStreamReader;
        }
        CompletableFuture<Void> writeFuture = writer != null ? writer.shutdown() : CompletableFuture.completedFuture(null);
        return writeFuture.whenCompleteAsync((aVoid, throwable) -> {
            if (reader != null) {
                reader.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStage<Void> closeConnection() {
        this.streamFeaturesManager.removeFeatureNegotiator(this.securityManager);
        this.streamFeaturesManager.removeFeatureNegotiator(this.compressionManager);
        this.streamFeaturesManager.removeFeatureNegotiator(this.streamManager);
        try {
            SocketConnection socketConnection = this;
            synchronized (socketConnection) {
                this.inputStream = null;
                this.outputStream = null;
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    finally {
                        this.socket = null;
                    }
                }
            }
            this.closeFuture.complete(null);
        }
        catch (IOException e) {
            this.closeFuture.completeExceptionally(e);
        }
        return this.closeFuture;
    }

    public final CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    public final InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("TCP connection");
        if (this.socket != null) {
            sb.append(" to ").append(this.socket.getInetAddress()).append(':').append(this.socket.getPort());
        }
        if (this.getStreamId() != null) {
            sb.append(" (").append(this.getStreamId()).append(')');
        }
        return sb.toString();
    }
}

