/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import rocks.xmpp.core.sasl.AuthenticationException;
import rocks.xmpp.core.sasl.XmppSaslClientFactory;
import rocks.xmpp.core.sasl.model.Auth;
import rocks.xmpp.core.sasl.model.Challenge;
import rocks.xmpp.core.sasl.model.Failure;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.sasl.model.Response;
import rocks.xmpp.core.sasl.model.Success;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.client.ClientStreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamElement;

final class AuthenticationManager
extends ClientStreamFeatureNegotiator<Mechanisms> {
    private static final Logger logger = Logger.getLogger(AuthenticationManager.class.getName());
    private final List<String> supportedMechanisms = new ArrayList<String>();
    private SaslClient saslClient;
    private byte[] successData;

    AuthenticationManager(XmppSession xmppSession) {
        super(xmppSession, Mechanisms.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startAuthentication(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler) throws StreamNegotiationException {
        AuthenticationManager authenticationManager = this;
        synchronized (authenticationManager) {
            try {
                ArrayDeque<String> clientMechanisms = new ArrayDeque<String>(mechanisms);
                clientMechanisms.retainAll(this.supportedMechanisms);
                if (clientMechanisms.isEmpty()) {
                    throw new StreamNegotiationException("Server doesn't support any of the requested SASL mechanisms: " + mechanisms + ".");
                }
                this.successData = null;
                this.saslClient = Sasl.createSaslClient(clientMechanisms.toArray(new String[clientMechanisms.size()]), authorizationId, "xmpp", this.xmppSession.getDomain().toString(), Collections.emptyMap(), callbackHandler);
                if (this.saslClient == null) {
                    throw new SaslException("No SASL client found for mechanisms: " + clientMechanisms);
                }
                byte[] initialResponse = null;
                if (this.saslClient.hasInitialResponse()) {
                    initialResponse = this.saslClient.evaluateChallenge(new byte[0]);
                }
                this.xmppSession.send((StreamElement)new Auth(this.saslClient.getMechanismName(), initialResponse));
            }
            catch (SaslException e) {
                throw new StreamNegotiationException((Throwable)e);
            }
        }
    }

    public final synchronized StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        block12: {
            try {
                if (element instanceof Mechanisms) {
                    this.supportedMechanisms.clear();
                    this.supportedMechanisms.addAll(((Mechanisms)element).getMechanisms());
                    break block12;
                }
                if (element instanceof Challenge) {
                    this.xmppSession.send((StreamElement)new Response(this.saslClient.evaluateChallenge(((Challenge)element).getValue())));
                    break block12;
                }
                if (element instanceof Failure) {
                    Failure authenticationFailure = (Failure)element;
                    String failureText = this.saslClient.getMechanismName() + " authentication failed with condition " + authenticationFailure.toString();
                    if (authenticationFailure.getText() != null) {
                        failureText = failureText + " (" + authenticationFailure.getText() + ')';
                    }
                    throw new AuthenticationException(failureText, authenticationFailure);
                }
                if (!(element instanceof Success)) break block12;
                this.successData = ((Success)element).getAdditionalData();
                if (!this.saslClient.isComplete()) {
                    this.saslClient.evaluateChallenge(this.successData);
                }
                try {
                    this.saslClient.dispose();
                    this.saslClient = null;
                }
                catch (SaslException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                return StreamNegotiationResult.RESTART;
            }
            catch (SaslException e) {
                AuthenticationException authenticationException = new AuthenticationException(e.getMessage());
                try {
                    if (this.saslClient != null) {
                        this.saslClient.dispose();
                        this.saslClient = null;
                    }
                }
                catch (SaslException disposeException) {
                    authenticationException.addSuppressed(disposeException);
                }
                throw authenticationException;
            }
        }
        return StreamNegotiationResult.INCOMPLETE;
    }

    public final boolean canProcess(Object element) {
        return element instanceof Challenge || element instanceof Failure || element instanceof Success;
    }

    synchronized byte[] getSuccessData() {
        return this.successData;
    }

    static {
        Security.addProvider(new XmppProvider());
    }

    private static final class XmppProvider
    extends Provider {
        XmppProvider() {
            super("XMPP Sasl Provider", 1.0, "Provides additional SASL mechanisms, which are required for XMPP.");
            this.put("SaslClientFactory.ANONYMOUS", XmppSaslClientFactory.class.getName());
            this.put("SaslClientFactory.SCRAM-SHA-1", XmppSaslClientFactory.class.getName());
        }
    }
}

