/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.caps.model.EntityCapabilities1;
import rocks.xmpp.extensions.caps2.model.EntityCapabilities2;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.hashes.model.Hashed;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.cache.LruCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class EntityCapabilitiesManager
extends Manager {
    private static final Logger logger = Logger.getLogger(EntityCapabilitiesManager.class.getName());
    private static final String DEFAULT_NODE = "http://xmpp.rocks";
    private static final Map<Hash, InfoNode> CAPS_CACHE = new LruCache(100);
    private static final Map<Jid, InfoNode> ENTITY_CAPABILITIES = new ConcurrentHashMap<Jid, InfoNode>();
    private static final Map<Jid, AsyncResult<InfoNode>> REQUESTS = new ConcurrentHashMap<Jid, AsyncResult<InfoNode>>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Map<InfoNode, Collection<EntityCapabilities>> publishedNodes;
    private final DirectoryCache directoryCapsCache;
    private final Consumer<PresenceEvent> inboundPresenceListener;
    private final Consumer<PresenceEvent> outboundPresenceListener;
    private boolean capsSent;
    private String node;

    private EntityCapabilitiesManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = xmppSession.getManager(ServiceDiscoveryManager.class);
        this.directoryCapsCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("caps")) : null;
        this.publishedNodes = new LinkedHashMap<InfoNode, Collection<EntityCapabilities>>(10, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<InfoNode, Collection<EntityCapabilities>> eldest) {
                if (this.size() > 10) {
                    EntityCapabilitiesManager.this.serviceDiscoveryManager.removeInfoNode(eldest.getKey().getNode());
                    return true;
                }
                return false;
            }
        };
        this.inboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (!presence.getFrom().equals(xmppSession.getConnectedResource())) {
                List entityCapabilities = presence.getExtensions(EntityCapabilities.class);
                this.processNextEntityCaps(entityCapabilities.iterator(), presence.getFrom());
            }
        };
        this.outboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.isAvailable()) {
                Map<InfoNode, Collection<EntityCapabilities>> map = this.publishedNodes;
                synchronized (map) {
                    if (this.publishedNodes.isEmpty()) {
                        this.publishCapsNode();
                    }
                    ArrayDeque<Collection<EntityCapabilities>> publishedEntityCaps = new ArrayDeque<Collection<EntityCapabilities>>(this.publishedNodes.values());
                    Collection lastPublishedEntityCaps = (Collection)publishedEntityCaps.getLast();
                    for (EntityCapabilities entityCapabilities : lastPublishedEntityCaps) {
                        presence.putExtension((Object)entityCapabilities);
                    }
                    this.capsSent = true;
                }
            }
        };
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
    }

    @Override
    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
    }

    @Override
    protected void initialize() {
        this.serviceDiscoveryManager.addCapabilitiesChangeListener(evt -> {
            Presence lastPresence = null;
            Map<InfoNode, Collection<EntityCapabilities>> map = this.publishedNodes;
            synchronized (map) {
                if (this.capsSent) {
                    this.publishCapsNode();
                    PresenceManager presenceManager = this.xmppSession.getManager(PresenceManager.class);
                    lastPresence = presenceManager.getLastSentPresence();
                }
            }
            if (lastPresence != null) {
                this.xmppSession.send((StreamElement)new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null));
            }
        });
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case AUTHENTICATED: {
                    List<EntityCapabilities> serverCapabilities = this.xmppSession.getManager(StreamFeaturesManager.class).getFeatures(EntityCapabilities.class);
                    this.processNextEntityCaps(serverCapabilities.iterator(), this.xmppSession.getDomain());
                    break;
                }
            }
        });
    }

    private void publishCapsNode() {
        final InfoDiscovery infoDiscovery = new InfoDiscovery(this.serviceDiscoveryManager.getIdentities(), this.serviceDiscoveryManager.getFeatures(), this.serviceDiscoveryManager.getExtensions());
        ArrayList<Object> caps = new ArrayList<Object>();
        try {
            EntityCapabilities1 entityCapabilities1 = new EntityCapabilities1(this.getNode(), (InfoNode)infoDiscovery, MessageDigest.getInstance("sha-1"));
            EntityCapabilities2 entityCapabilities2 = new EntityCapabilities2((InfoNode)infoDiscovery, new MessageDigest[]{MessageDigest.getInstance("sha-256")});
            caps.add(entityCapabilities1);
            caps.add(entityCapabilities2);
            this.publishedNodes.put((InfoNode)infoDiscovery, caps);
            for (EntityCapabilities entityCapabilities : caps) {
                Set capabilityHashSet = entityCapabilities.getCapabilityHashSet();
                for (Hashed hashed : capabilityHashSet) {
                    this.writeToCache(Hash.from((Hashed)hashed), (InfoNode)infoDiscovery);
                    final String node = entityCapabilities.createCapabilityHashNode(hashed);
                    this.serviceDiscoveryManager.addInfoNode(new InfoNode(){

                        public String getNode() {
                            return node;
                        }

                        public Set<Identity> getIdentities() {
                            return infoDiscovery.getIdentities();
                        }

                        public Set<String> getFeatures() {
                            return infoDiscovery.getFeatures();
                        }

                        public List<DataForm> getExtensions() {
                            return infoDiscovery.getExtensions();
                        }
                    });
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public synchronized String getNode() {
        return this.node != null ? this.node : DEFAULT_NODE;
    }

    public synchronized void setNode(String node) {
        this.node = node;
    }

    public final AsyncResult<InfoNode> discoverCapabilities(Jid jid) {
        InfoNode infoNode = ENTITY_CAPABILITIES.get(jid);
        if (infoNode == null) {
            return REQUESTS.computeIfAbsent(jid, key -> this.serviceDiscoveryManager.discoverInformation(jid).whenComplete((result, e) -> {
                if (result != null) {
                    ENTITY_CAPABILITIES.put(jid, (InfoNode)result);
                }
                REQUESTS.remove(jid);
            }));
        }
        return new AsyncResult(CompletableFuture.completedFuture(infoNode));
    }

    public final AsyncResult<Boolean> isSupported(String feature, Jid jid) {
        return this.discoverCapabilities(jid).handle((infoNode, e) -> {
            if (e == null) {
                return infoNode.getFeatures().contains(feature);
            }
            if (e.getCause() instanceof StanzaErrorException) {
                return false;
            }
            throw (CompletionException)e;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(Hash hash, InfoNode infoNode) {
        if (this.directoryCapsCache != null) {
            CAPS_CACHE.put(hash, infoNode);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(byteArrayOutputStream, StandardCharsets.UTF_8.name()));
                    this.xmppSession.createMarshaller().marshal((Object)infoNode, xmppStreamWriter);
                    xmppStreamWriter.flush();
                }
                this.directoryCapsCache.put(XmppUtils.hash((byte[])hash.toString().getBytes(StandardCharsets.UTF_8)) + ".caps", byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e, () -> "Could not write entity capabilities to persistent cache. Reason: " + e.getMessage());
            }
        }
    }

    private InfoNode readFromCache(Hash hash) {
        block9: {
            if (this.directoryCapsCache != null) {
                InfoNode infoNode;
                InfoNode infoNode2 = CAPS_CACHE.get(hash);
                if (infoNode2 != null) {
                    return infoNode2;
                }
                String fileName = XmppUtils.hash((byte[])hash.toString().getBytes(StandardCharsets.UTF_8)) + ".caps";
                byte[] bytes = this.directoryCapsCache.get((Object)fileName);
                if (bytes == null) break block9;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                Throwable throwable = null;
                try {
                    infoNode2 = (InfoNode)this.xmppSession.createUnmarshaller().unmarshal((InputStream)byteArrayInputStream);
                    CAPS_CACHE.put(hash, infoNode2);
                    infoNode = infoNode2;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            EntityCapabilitiesManager.$closeResource(throwable, byteArrayInputStream);
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e, () -> "Could not read entity capabilities from persistent cache (file: " + fileName + ')');
                    }
                }
                EntityCapabilitiesManager.$closeResource(throwable, byteArrayInputStream);
                return infoNode;
            }
        }
        return null;
    }

    private void processNextEntityCaps(Iterator<EntityCapabilities> entityCapabilities, Jid entity) {
        if (entityCapabilities.hasNext()) {
            EntityCapabilities caps = entityCapabilities.next();
            logger.log(Level.FINE, "Processing {0}", caps);
            this.processNextHash(entityCapabilities, caps.getCapabilityHashSet().iterator(), entity, caps);
        }
    }

    private void processNextHash(Iterator<EntityCapabilities> entityCapabilities, Iterator<Hashed> hashedIterator, Jid entity, EntityCapabilities caps) {
        if (hashedIterator.hasNext()) {
            Hashed hashed = hashedIterator.next();
            if (hashed.getHashAlgorithm() == null) {
                return;
            }
            Hash hash = Hash.from((Hashed)hashed);
            InfoNode infoNode = this.readFromCache(hash);
            if (infoNode != null) {
                ENTITY_CAPABILITIES.put(entity, infoNode);
            } else {
                String nodeToDiscover = caps.createCapabilityHashNode((Hashed)hash);
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(hash.getHashAlgorithm());
                    logger.log(Level.FINE, "Discovering capabilities for '{0}' at node {1}", new Object[]{entity, nodeToDiscover});
                    this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover).whenComplete((infoDiscovery, e1) -> {
                        if (e1 != null) {
                            this.processNextHash(entityCapabilities, hashedIterator, entity, caps);
                            logger.log(Level.WARNING, (Throwable)e1, () -> "Failed to discover information for entity '" + entity + "' for node '" + nodeToDiscover + "'");
                        } else {
                            ArrayDeque<String> ftValues = new ArrayDeque<String>();
                            for (DataForm dataForm : infoDiscovery.getExtensions()) {
                                DataForm.Field formType = dataForm.findField("FORM_TYPE");
                                if (formType == null || formType.getType() != DataForm.Field.Type.HIDDEN || formType.getValues().isEmpty()) continue;
                                ArrayDeque<String> values = new ArrayDeque<String>();
                                for (String value : formType.getValues()) {
                                    if (values.contains(value)) {
                                        return;
                                    }
                                    values.add(value);
                                }
                                String value = (String)formType.getValues().get(0);
                                if (ftValues.contains(value)) {
                                    return;
                                }
                                ftValues.add(value);
                            }
                            byte[] verificationString = caps.createVerificationString(infoDiscovery);
                            byte[] computedHash = messageDigest.digest(verificationString);
                            if (Arrays.equals(computedHash, hash.getHashValue())) {
                                this.writeToCache(hash, (InfoNode)infoDiscovery);
                            } else {
                                this.processNextHash(entityCapabilities, hashedIterator, entity, caps);
                            }
                            ENTITY_CAPABILITIES.put(entity, (InfoNode)infoDiscovery);
                        }
                    });
                }
                catch (NoSuchAlgorithmException e12) {
                    this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover).whenComplete((result, e2) -> {
                        if (e2 != null) {
                            logger.log(Level.WARNING, "Failed to discover information for entity '{0}' for node '{1}'", new Object[]{entity, nodeToDiscover});
                        } else {
                            ENTITY_CAPABILITIES.put(entity, (InfoNode)result);
                        }
                    });
                    this.processNextHash(entityCapabilities, hashedIterator, entity, caps);
                }
            }
        } else {
            this.processNextEntityCaps(entityCapabilities, entity);
        }
    }
}

