/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.CompletionStages;

public final class BoshConnection
extends AbstractConnection {
    private static final Logger logger = Logger.getLogger(BoshConnection.class.getName());
    final Map<Long, Body.Builder> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body.Builder>();
    private final AtomicLong rid = new AtomicLong();
    private final BoshConnectionConfiguration boshConnectionConfiguration;
    private final XmppDebugger debugger;
    private final XmppSession xmppSession;
    private final Deque<String> keySequence = new ArrayDeque<String>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Map<String, CompressionMethod> compressionMethods;
    private final Map<StreamElement, CompletableFuture<Void>> sendFutures = new ConcurrentHashMap<StreamElement, CompletableFuture<Void>>();
    private final Collection<Object> elementsToSend = new ArrayDeque<Object>();
    private final String clientAcceptEncoding;
    private final URL url;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private ExecutorService httpBindExecutor;
    private CompressionMethod requestCompressionMethod;
    private long highestReceivedRid;
    private String sessionId;
    private boolean usingAcknowledgments;
    private SessionOpen sessionOpen;

    BoshConnection(URL url, XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super((ConnectionConfiguration)configuration);
        this.url = url;
        this.xmppSession = xmppSession;
        this.boshConnectionConfiguration = configuration;
        this.debugger = xmppSession.getDebugger();
        this.compressionMethods = new LinkedHashMap<String, CompressionMethod>();
        for (CompressionMethod compressionMethod : this.boshConnectionConfiguration.getCompressionMethods()) {
            this.compressionMethods.put(compressionMethod.getName(), compressionMethod);
        }
        this.clientAcceptEncoding = !this.compressionMethods.isEmpty() ? String.join((CharSequence)",", this.compressionMethods.keySet()) : null;
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST, httpCode);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION, httpCode);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND, httpCode);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    private void generateKeySequence() {
        this.keySequence.clear();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            SecureRandom random = new SecureRandom();
            int n = 256 + random.nextInt(32512);
            byte[] seed = new byte[1024];
            ((Random)random).nextBytes(seed);
            String kn = DatatypeConverter.printHexBinary((byte[])seed).toLowerCase();
            for (int i = 0; i < n; ++i) {
                kn = DatatypeConverter.printHexBinary((byte[])digest.digest(kn.getBytes(StandardCharsets.UTF_8))).toLowerCase();
                this.keySequence.add(kn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    final synchronized void connect() throws IOException {
        if (this.sessionId != null) {
            return;
        }
        this.sessionId = null;
        this.usingAcknowledgments = false;
        this.requestCompressionMethod = null;
        this.requestCount.set(0);
        this.rid.set(new BigInteger(52, new Random()).longValue());
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection();
            connection.setConnectTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.setReadTimeout(this.boshConnectionConfiguration.getConnectTimeout());
            connection.connect();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        this.httpBindExecutor = Executors.newFixedThreadPool(2, this.xmppSession.getConfiguration().getThreadFactory("XMPP BOSH Request Thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            this.sessionOpen = sessionOpen;
        }
        Body.Builder body = Body.builder().language(this.xmppSession.getConfiguration().getLanguage()).version("1.11").wait(this.boshConnectionConfiguration.getWait()).hold((short)1).route(this.boshConnectionConfiguration.getRoute()).ack(1L).from(sessionOpen.getFrom()).xmppVersion("1.0");
        if (this.xmppSession.getDomain() != null) {
            body.to(this.xmppSession.getDomain());
        }
        return this.sendNewRequest(body, false);
    }

    public final boolean isSecure() {
        return this.boshConnectionConfiguration.getChannelEncryption() == ChannelEncryption.DIRECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBody(Body responseBody) throws Exception {
        if (responseBody.getSid() != null) {
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                this.openedByPeer((SessionOpen)responseBody);
                this.sessionId = responseBody.getSid();
                if (responseBody.getAck() != null) {
                    this.usingAcknowledgments = true;
                }
                if (responseBody.getAccept() != null) {
                    String[] serverAcceptedEncodings;
                    for (String serverAcceptedEncoding : serverAcceptedEncodings = responseBody.getAccept().split(",", 16)) {
                        this.requestCompressionMethod = this.compressionMethods.get(serverAcceptedEncoding.trim().toLowerCase());
                        if (this.requestCompressionMethod != null) break;
                    }
                }
                this.xmppSession.handleElement(responseBody);
            }
        }
        if (responseBody.getAck() != null) {
            this.ackReceived(responseBody.getAck());
        }
        if (responseBody.getType() == Body.Type.TERMINATE && responseBody.getCondition() != null && responseBody.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
            this.shutdown();
            this.closeFuture.completeExceptionally((Throwable)((Object)new BoshException(responseBody.getCondition(), responseBody.getUri())));
            throw new BoshException(responseBody.getCondition(), responseBody.getUri());
        }
        if (responseBody.getType() == Body.Type.ERROR) {
            this.unacknowledgedRequests.forEach((key, value) -> this.sendNewRequest((Body.Builder)value, true));
        }
        for (Object wrappedObject : responseBody.getWrappedObjects()) {
            if (!this.xmppSession.handleElement(wrappedObject)) continue;
            this.restartStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void restartStream() {
        Body.Builder bodyBuilder;
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            bodyBuilder = Body.builder().sessionId(this.sessionId).restart(true).to(this.xmppSession.getDomain()).language(this.xmppSession.getConfiguration().getLanguage()).from(this.sessionOpen.getFrom());
        }
        this.sendNewRequest(bodyBuilder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStage<Void> closeStream() {
        CompletionStage<Object> future;
        ExecutorService executorService;
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            executorService = this.httpBindExecutor;
        }
        if (executorService != null && !executorService.isShutdown()) {
            String sid = this.getSessionId();
            if (sid != null) {
                Body.Builder bodyBuilder = Body.builder().sessionId(sid).type(Body.Type.TERMINATE);
                future = ((CompletableFuture)this.sendNewRequest(bodyBuilder, false).applyToEither(CompletionStages.timeoutAfter((long)500L, (TimeUnit)TimeUnit.MILLISECONDS), Function.identity())).exceptionally(exc -> null);
            } else {
                future = CompletableFuture.completedFuture(null);
            }
            executorService.shutdown();
        } else {
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    protected CompletionStage<Void> closeConnection() {
        return CompletableFuture.runAsync(() -> {
            try {
                BoshConnection boshConnection = this;
                synchronized (boshConnection) {
                    if (this.httpBindExecutor != null) {
                        this.httpBindExecutor.shutdown();
                        try {
                            if (!this.httpBindExecutor.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                                this.httpBindExecutor.shutdownNow();
                            }
                        }
                        catch (InterruptedException e) {
                            this.httpBindExecutor.shutdownNow();
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.sessionId = null;
                    this.requestCompressionMethod = null;
                    this.keySequence.clear();
                }
            }
            finally {
                this.closeFuture.complete(null);
            }
        });
    }

    public final CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    private synchronized void shutdown() {
        if (this.httpBindExecutor != null) {
            this.httpBindExecutor.shutdown();
        }
    }

    public final long detach() {
        this.shutdown();
        return this.rid.get();
    }

    public final CompletableFuture<Void> send(StreamElement element) {
        CompletionStage future = this.write(element);
        this.flush();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletableFuture<Void> write(StreamElement streamElement) {
        Collection<Object> collection = this.elementsToSend;
        synchronized (collection) {
            this.elementsToSend.add(streamElement);
        }
        CompletableFuture<Void> sendFuture = new CompletableFuture<Void>();
        this.sendFutures.put(streamElement, sendFuture);
        return sendFuture;
    }

    public final void flush() {
        this.sendNewRequest(Body.builder().sessionId(this.getSessionId()), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendKey(Body.Builder bodyBuilder) {
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                if (this.keySequence.isEmpty()) {
                    this.generateKeySequence();
                    bodyBuilder.newKey(this.keySequence.removeLast());
                } else {
                    bodyBuilder.key(this.keySequence.removeLast());
                    if (this.keySequence.isEmpty()) {
                        this.generateKeySequence();
                        bodyBuilder.newKey(this.keySequence.removeLast());
                    }
                }
            }
        }
    }

    public final synchronized String getSessionId() {
        return this.sessionId;
    }

    public final InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.url.getHost(), this.url.getPort());
    }

    public final synchronized boolean isUsingAcknowledgements() {
        return this.usingAcknowledgments;
    }

    private CompletableFuture<Void> sendNewRequest(Body.Builder bodyBuilder, boolean resendAfterError) {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                return CompletableFuture.runAsync(() -> {
                    block82: {
                        HttpURLConnection httpConnection = null;
                        boolean responseReceived = false;
                        Body body = null;
                        try {
                            CompressionMethod compressionMethod;
                            Object object;
                            if (!resendAfterError) {
                                ExecutorService executor;
                                object = this;
                                synchronized (object) {
                                    executor = this.httpBindExecutor;
                                }
                                object = this.elementsToSend;
                                synchronized (object) {
                                    block79: {
                                        this.appendKey(bodyBuilder);
                                        if (!this.unacknowledgedRequests.isEmpty()) {
                                            bodyBuilder.ack(this.highestReceivedRid);
                                        }
                                        bodyBuilder.wrappedObjects(this.elementsToSend);
                                        body = bodyBuilder.build();
                                        if (body.getType() == Body.Type.TERMINATE || executor != null && !executor.isShutdown() && (this.requestCount.get() <= 0 || body.getPause() != null || body.isRestart() || this.getSessionId() == null || !this.elementsToSend.isEmpty())) break block79;
                                        return;
                                    }
                                    this.elementsToSend.clear();
                                }
                            }
                            httpConnection = this.getConnection();
                            httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                            if (this.clientAcceptEncoding != null) {
                                httpConnection.setRequestProperty("Accept-Encoding", this.clientAcceptEncoding);
                            }
                            object = this;
                            synchronized (object) {
                                compressionMethod = this.requestCompressionMethod;
                            }
                            if (compressionMethod != null) {
                                httpConnection.setRequestProperty("Content-Encoding", compressionMethod.getName());
                            }
                            httpConnection.setDoOutput(true);
                            httpConnection.setRequestMethod("POST");
                            httpConnection.setReadTimeout(((int)this.boshConnectionConfiguration.getWait().getSeconds() + 5) * 1000);
                            this.requestCount.getAndIncrement();
                            try {
                                Object requestStream = compressionMethod != null ? compressionMethod.compress(httpConnection.getOutputStream()) : httpConnection.getOutputStream();
                                Throwable throwable = null;
                                try {
                                    ByteArrayOutputStream byteArrayOutputStreamRequest = null;
                                    XMLStreamWriter xmlStreamWriter = null;
                                    OutputStream xmppOutputStream = null;
                                    try {
                                        OutputStream debuggerOutputStream;
                                        if (this.debugger != null && (debuggerOutputStream = this.debugger.createOutputStream(xmppOutputStream = XmppUtils.createBranchedOutputStream((OutputStream)requestStream, (OutputStream)(byteArrayOutputStreamRequest = new ByteArrayOutputStream())))) != null) {
                                            xmppOutputStream = debuggerOutputStream;
                                        }
                                        if (xmppOutputStream == null) {
                                            xmppOutputStream = requestStream;
                                        }
                                        xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(xmppOutputStream, StandardCharsets.UTF_8.name()));
                                        body = bodyBuilder.requestId(this.rid.getAndIncrement()).build();
                                        this.xmppSession.createMarshaller().marshal((Object)body, xmlStreamWriter);
                                        xmlStreamWriter.flush();
                                        if (this.debugger != null) {
                                            this.debugger.writeStanza(new String(byteArrayOutputStreamRequest.toByteArray(), StandardCharsets.UTF_8), body);
                                        }
                                        body.getWrappedObjects().stream().filter(wrappedObject -> wrappedObject instanceof StreamElement).forEach(wrappedObject -> {
                                            StreamElement streamElement = (StreamElement)wrappedObject;
                                            CompletableFuture<Void> future = this.sendFutures.remove(streamElement);
                                            if (future != null) {
                                                future.complete(null);
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        this.rid.getAndDecrement();
                                        throw e;
                                    }
                                    finally {
                                        if (xmlStreamWriter != null) {
                                            xmlStreamWriter.close();
                                        }
                                        if (xmppOutputStream != null) {
                                            xmppOutputStream.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (requestStream != null) {
                                        BoshConnection.$closeResource(throwable, (AutoCloseable)requestStream);
                                    }
                                }
                                if (this.isUsingAcknowledgements()) {
                                    this.unacknowledgedRequests.put(body.getRid(), bodyBuilder);
                                }
                                if (httpConnection.getResponseCode() == 200) {
                                    responseReceived = true;
                                    this.ackReceived(body.getRid());
                                    requestStream = this.elementsToSend;
                                    synchronized (requestStream) {
                                        this.highestReceivedRid = body.getRid() != null ? body.getRid() : 0L;
                                    }
                                    String contentEncoding = httpConnection.getHeaderField("Content-Encoding");
                                    InputStream responseStream = contentEncoding != null ? this.compressionMethods.get(contentEncoding).decompress(httpConnection.getInputStream()) : httpConnection.getInputStream();
                                    Throwable throwable3 = null;
                                    try {
                                        InputStream xmppInputStream = null;
                                        ByteArrayOutputStream byteArrayOutputStream = null;
                                        XMLEventReader xmlEventReader = null;
                                        try {
                                            InputStream debuggerInputStream;
                                            if (this.debugger != null && (debuggerInputStream = this.debugger.createInputStream(xmppInputStream = XmppUtils.createBranchedInputStream((InputStream)responseStream, (OutputStream)(byteArrayOutputStream = new ByteArrayOutputStream())))) != null) {
                                                xmppInputStream = debuggerInputStream;
                                            }
                                            if (xmppInputStream == null) {
                                                xmppInputStream = responseStream;
                                            }
                                            xmlEventReader = this.xmppSession.getConfiguration().getXmlInputFactory().createXMLEventReader(xmppInputStream, "UTF-8");
                                            while (xmlEventReader.hasNext()) {
                                                XMLEvent xmlEvent = xmlEventReader.peek();
                                                if (xmlEvent.isStartElement()) {
                                                    JAXBElement element = this.xmppSession.createUnmarshaller().unmarshal(xmlEventReader, Body.class);
                                                    if (this.debugger != null) {
                                                        this.debugger.readStanza(new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8), element.getValue());
                                                    }
                                                    this.unpackBody((Body)element.getValue());
                                                    continue;
                                                }
                                                xmlEventReader.next();
                                            }
                                        }
                                        catch (JAXBException e) {
                                            logger.log(Level.WARNING, "Server responded with malformed XML.", e);
                                        }
                                        finally {
                                            if (xmlEventReader != null) {
                                                xmlEventReader.close();
                                            }
                                            if (xmppInputStream != null) {
                                                xmppInputStream.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (responseStream != null) {
                                            BoshConnection.$closeResource(throwable3, responseStream);
                                        }
                                    }
                                    Thread.sleep(50L);
                                    break block82;
                                }
                                this.shutdown();
                                BoshConnection.handleCode(httpConnection.getResponseCode());
                                InputStream errorStream = httpConnection.getErrorStream();
                                throwable = null;
                                try {
                                    while (errorStream.read() > -1) {
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (errorStream != null) {
                                        BoshConnection.$closeResource(throwable, errorStream);
                                    }
                                }
                            }
                            finally {
                                if (this.requestCount.decrementAndGet() == 0 && responseReceived) {
                                    object = this;
                                    synchronized (object) {
                                        if (this.httpBindExecutor != null && !this.httpBindExecutor.isShutdown()) {
                                            this.sendNewRequest(Body.builder().sessionId(this.sessionId), false);
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.xmppSession.notifyException(e);
                            if (body != null) {
                                body.getWrappedObjects().stream().filter(wrappedObject -> wrappedObject instanceof StreamElement).forEach(wrappedObject -> {
                                    StreamElement streamElement = (StreamElement)wrappedObject;
                                    CompletableFuture<Void> future = this.sendFutures.remove(streamElement);
                                    if (future != null) {
                                        future.completeExceptionally(e);
                                    }
                                });
                            }
                            throw new CompletionException(e);
                        }
                        finally {
                            if (httpConnection != null) {
                                httpConnection.disconnect();
                            }
                        }
                    }
                }, this.httpBindExecutor);
            }
            throw new IllegalStateException("Connection already shutdown via close() or detach()");
        }
    }

    private void ackReceived(Long rid) {
        Body.Builder body;
        if (rid != null && (body = this.unacknowledgedRequests.remove(rid)) != null) {
            body.build().getWrappedObjects().stream().filter(object -> object instanceof Stanza).forEach(object -> {
                Stanza stanza = (Stanza)object;
                this.xmppSession.markAcknowledged(stanza);
            });
        }
    }

    private HttpURLConnection getConnection() throws IOException {
        Proxy proxy = this.boshConnectionConfiguration.getProxy();
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            if (this.boshConnectionConfiguration.getSSLContext() != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
            }
            if (this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.boshConnectionConfiguration.getHostnameVerifier());
            }
        }
        return httpURLConnection;
    }

    public final String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("BOSH connection at ").append(this.url);
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        return sb.toString();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

