/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.SocketConnection;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;

public final class SocketConnectionConfiguration
extends TcpConnectionConfiguration<Socket> {
    private static volatile SocketConnectionConfiguration defaultConfiguration;
    private final SocketFactory socketFactory;

    protected SocketConnectionConfiguration(Builder builder) {
        super(builder);
        this.socketFactory = builder.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<SocketConnectionConfiguration> clazz = SocketConnectionConfiguration.class;
        synchronized (SocketConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = SocketConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(SocketConnectionConfiguration configuration) {
        Class<SocketConnectionConfiguration> clazz = SocketConnectionConfiguration.class;
        synchronized (SocketConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final Connection createConnection(XmppSession xmppSession) throws Exception {
        return this.createConnection(xmppSession, socket -> new SocketConnection((Socket)socket, xmppSession, this));
    }

    public final SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    protected final Socket connect(String hostname, int port) throws IOException {
        Socket socket = this.getSocketFactory() == null ? (this.getProxy() != null ? new Socket(this.getProxy()) : new Socket()) : this.getSocketFactory().createSocket();
        if (!socket.isConnected()) {
            socket.connect(new InetSocketAddress(hostname, port), this.getConnectTimeout());
        }
        return socket;
    }

    public static final class Builder
    extends TcpConnectionConfiguration.Builder<Builder> {
        private SocketFactory socketFactory;

        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SocketConnectionConfiguration build() {
            return new SocketConnectionConfiguration(this);
        }
    }
}

