/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.SrvRecord;

public abstract class TcpConnectionConfiguration<T>
extends ClientConnectionConfiguration {
    private final int keepAliveInterval;

    protected TcpConnectionConfiguration(Builder<? extends Builder> builder) {
        super(builder);
        this.keepAliveInterval = ((Builder)builder).keepAliveInterval;
    }

    public final int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    protected final Connection createConnection(XmppSession xmppSession, Function<T, TcpBinding> creator) throws Exception {
        T socket;
        if (this.getHostname() != null && !this.getHostname().isEmpty()) {
            socket = this.connect(this.getHostname(), this.getPort());
        } else if (xmppSession.getDomain() != null) {
            socket = this.connectWithXmppServiceDomain(xmppSession.getDomain(), xmppSession.getConfiguration().getNameServer());
            if (socket == null) {
                socket = this.connect(xmppSession.getDomain().toString(), this.getPort());
            }
        } else {
            throw new IllegalStateException("Neither 'xmppServiceDomain' nor 'host' is set.");
        }
        TcpBinding tcpBinding = creator.apply(socket);
        if (this.getChannelEncryption() == ChannelEncryption.DIRECT) {
            tcpBinding.secureConnection();
        }
        return tcpBinding;
    }

    protected abstract T connect(String var1, int var2) throws Exception;

    private T connectWithXmppServiceDomain(Jid xmppServiceDomain, String nameServer) {
        try {
            List<SrvRecord> srvRecords = DnsResolver.resolveSRV("xmpp-client", (CharSequence)xmppServiceDomain, nameServer, this.getConnectTimeout());
            srvRecords.sort(null);
            IOException ex = null;
            for (SrvRecord srvRecord : srvRecords) {
                if (srvRecord == null) continue;
                if (".".equals(srvRecord.getTarget())) {
                    return null;
                }
                try {
                    return this.connect(srvRecord.getTarget(), srvRecord.getPort());
                }
                catch (IOException e) {
                    ex = e;
                }
            }
            if (!srvRecords.isEmpty()) {
                throw new IOException("Could not connect to any host.", ex);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ClientConnectionConfiguration.Builder<T> {
        private int keepAliveInterval;

        protected Builder() {
            this.channelEncryption(ChannelEncryption.OPTIONAL);
            this.port(5222);
            this.keepAliveInterval(30);
        }

        public final Builder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }
    }
}

