/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.client.SocketConnection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedExecutorService;

final class XmppStreamReader {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"XMPP Reader Thread"));
    private static final QName STREAM_ID = new QName("id");
    private static final QName FROM = new QName("from");
    private static final QName TO = new QName("to");
    private static final QName VERSION = new QName("version");
    private static final QName LANG = new QName("http://www.w3.org/XML/1998/namespace", "lang");
    private final SocketConnection connection;
    private final XmppSession xmppSession;
    private final ExecutorService executorService;
    private final XmppDebugger debugger;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final String namespace;

    XmppStreamReader(String namespace, SocketConnection connection, XmppSession xmppSession) {
        this.connection = connection;
        this.xmppSession = xmppSession;
        this.debugger = xmppSession.getDebugger();
        this.marshaller = xmppSession.createMarshaller();
        this.unmarshaller = xmppSession.createUnmarshaller();
        this.executorService = new QueuedExecutorService(EXECUTOR_SERVICE);
        this.namespace = namespace;
    }

    void startReading(InputStream inputStream, Consumer<SessionOpen> openedByPeer, Runnable closedByPeer) {
        this.executorService.execute(() -> {
            boolean doRestart = false;
            XMLEventReader xmlEventReader = null;
            StreamErrorException streamError = null;
            try {
                XMLEvent xmlEvent;
                InputStream xmppInputStream = null;
                if (this.debugger != null) {
                    xmppInputStream = this.debugger.createInputStream(inputStream);
                }
                if (xmppInputStream == null) {
                    xmppInputStream = inputStream;
                }
                XMLEvent startDocument = null;
                xmlEventReader = this.xmppSession.getConfiguration().getXmlInputFactory().createXMLEventReader(xmppInputStream, "UTF-8");
                while (!doRestart && (xmlEvent = xmlEventReader.peek()) != null) {
                    StringWriter stringWriter = null;
                    if (this.debugger != null) {
                        stringWriter = new StringWriter();
                        if (xmlEvent.isStartDocument()) {
                            startDocument = xmlEvent;
                        }
                    }
                    if (xmlEvent.isStartElement()) {
                        StartElement startElement = xmlEvent.asStartElement();
                        if ("stream".equals(startElement.getName().getLocalPart()) && "http://etherx.jabber.org/streams".equals(startElement.getName().getNamespaceURI())) {
                            Attribute idAttribute = startElement.getAttributeByName(STREAM_ID);
                            Attribute fromAttribute = startElement.getAttributeByName(FROM);
                            Attribute toAttribute = startElement.getAttributeByName(TO);
                            Attribute versionAttribute = startElement.getAttributeByName(VERSION);
                            Attribute langAttribute = startElement.getAttributeByName(LANG);
                            Jid from = fromAttribute != null ? Jid.ofEscaped((CharSequence)fromAttribute.getValue()) : null;
                            Jid to = toAttribute != null ? Jid.ofEscaped((CharSequence)toAttribute.getValue()) : null;
                            String id = idAttribute != null ? idAttribute.getValue() : null;
                            String version = versionAttribute != null ? versionAttribute.getValue() : null;
                            Locale lang = langAttribute != null ? Locale.forLanguageTag(langAttribute.getValue()) : null;
                            StreamHeader streamHeader = StreamHeader.create((Jid)from, (Jid)to, (String)id, (String)version, (Locale)lang, (String)this.namespace, (QName[])new QName[0]);
                            openedByPeer.accept((SessionOpen)streamHeader);
                            if (this.debugger != null) {
                                XMLEventWriter writer = this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLEventWriter(stringWriter);
                                writer.add(startDocument);
                                writer.add(xmlEvent);
                                writer.flush();
                                this.debugger.readStanza(stringWriter.append('>').toString(), null);
                                writer.close();
                            }
                            this.xmppSession.handleElement(streamHeader);
                            xmlEventReader.nextEvent();
                        } else {
                            Object object = this.unmarshaller.unmarshal(xmlEventReader);
                            if (this.debugger != null) {
                                XMLStreamWriter xmlStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(stringWriter));
                                xmlStreamWriter.setDefaultNamespace(this.namespace);
                                this.marshaller.marshal(object, xmlStreamWriter);
                                xmlStreamWriter.flush();
                                this.debugger.readStanza(stringWriter.toString(), object);
                            }
                            try {
                                doRestart = this.xmppSession.handleElement(object);
                            }
                            catch (StreamErrorException e) {
                                streamError = e;
                            }
                            catch (XmppException e) {
                                this.xmppSession.notifyException(e);
                            }
                        }
                    } else {
                        xmlEventReader.nextEvent();
                    }
                    if (!xmlEvent.isEndElement()) continue;
                    closedByPeer.run();
                    if (this.debugger == null) continue;
                    QName qName = xmlEvent.asEndElement().getName();
                    this.debugger.readStanza("</" + qName.getPrefix() + ':' + qName.getLocalPart() + '>', null);
                }
                xmlEventReader.close();
                if (streamError != null) {
                    throw streamError;
                }
                if (!doRestart && this.xmppSession.getStatus() != XmppSession.Status.CLOSING) {
                    throw new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "Stream closed by server", Locale.ENGLISH, null));
                }
            }
            catch (Exception e) {
                this.executorService.shutdown();
                if (streamError != null) {
                    this.xmppSession.notifyException(streamError);
                } else {
                    this.xmppSession.notifyException(e);
                }
            }
            finally {
                if (xmlEventReader != null) {
                    try {
                        xmlEventReader.close();
                    }
                    catch (XMLStreamException e) {
                        this.xmppSession.notifyException(e);
                    }
                }
                if (doRestart) {
                    this.connection.restartStream();
                }
            }
        });
    }

    void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

