/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.client.ClientStreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

public final class CompressionManager
extends ClientStreamFeatureNegotiator<CompressionFeature> {
    private static final Logger logger = Logger.getLogger(CompressionManager.class.getName());
    private final TcpBinding tcpBinding;
    private final List<CompressionMethod> compressionMethods = new CopyOnWriteArrayList<CompressionMethod>();
    private CompressionMethod negotiatedCompressionMethod;

    public CompressionManager(XmppSession xmppSession, TcpBinding tcpBinding) {
        super(xmppSession, CompressionFeature.class);
        this.tcpBinding = tcpBinding;
    }

    public final StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        if (this.compressionMethods.isEmpty()) {
            return StreamNegotiationResult.IGNORE;
        }
        if (element instanceof CompressionFeature) {
            List advertisedCompressionMethods = ((CompressionFeature)element).getMethods();
            LinkedHashMap<String, CompressionMethod> clientMethods = new LinkedHashMap<String, CompressionMethod>();
            for (CompressionMethod compressionMethod : this.compressionMethods) {
                clientMethods.put(compressionMethod.getName(), compressionMethod);
            }
            clientMethods.keySet().retainAll(advertisedCompressionMethods);
            if (!clientMethods.isEmpty()) {
                CompressionMethod compressionMethod = (CompressionMethod)clientMethods.values().iterator().next();
                this.xmppSession.send((StreamElement)new StreamCompression.Compress(compressionMethod.getName()));
                this.negotiatedCompressionMethod = compressionMethod;
                return StreamNegotiationResult.INCOMPLETE;
            }
            return StreamNegotiationResult.IGNORE;
        }
        if (element == StreamCompression.COMPRESSED) {
            try {
                this.tcpBinding.compressConnection(this.negotiatedCompressionMethod.getName(), null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failure during stream compression.", e);
                return StreamNegotiationResult.IGNORE;
            }
            logger.fine("Stream is now compressed.");
            return StreamNegotiationResult.RESTART;
        }
        if (element instanceof StreamCompression.Failure) {
            this.negotiatedCompressionMethod = null;
            logger.warning("Failure during compression negotiation: " + ((StreamCompression.Failure)element).getCondition());
            return StreamNegotiationResult.IGNORE;
        }
        return StreamNegotiationResult.IGNORE;
    }

    public final boolean canProcess(Object element) {
        return element instanceof StreamCompression;
    }

    public final CompressionMethod getNegotiatedCompressionMethod() {
        return this.negotiatedCompressionMethod;
    }

    public final List<CompressionMethod> getConfiguredCompressionMethods() {
        return this.compressionMethods;
    }
}

