/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.client.ClientStreamFeatureNegotiator;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.sm.RequestStrategies;
import rocks.xmpp.extensions.sm.model.StreamManagement;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class StreamManager
extends ClientStreamFeatureNegotiator<StreamManagement> {
    private static final long MAX_H = 0xFFFFFFFFL;
    private final Queue<Stanza> unacknowledgedStanzas = new ConcurrentLinkedDeque<Stanza>();
    long inboundCount = 0L;
    private long acknowledgedStanzaCount = 0L;
    private boolean enabledByClient;
    private StreamManagement.Enabled enabled;
    private Predicate<Stanza> requestStrategy = RequestStrategies.forEachMessageOrEveryXStanzas(3);
    private CompletableFuture<Boolean> resumeFuture;

    private StreamManager(XmppSession xmppSession) {
        super(xmppSession, StreamManagement.class);
        xmppSession.addSessionStatusListener(sessionStatusEvent -> {
            if (sessionStatusEvent.getStatus() == XmppSession.Status.CLOSING && this.isActive()) {
                StreamManagement.Answer answer;
                StreamManager streamManager = this;
                synchronized (streamManager) {
                    answer = new StreamManagement.Answer(this.inboundCount);
                }
                xmppSession.send((StreamElement)answer);
            }
        });
    }

    static long diff(long h, long acknowledgedCount) {
        return h - acknowledgedCount & 0xFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StreamNegotiationResult processNegotiation(Object element) {
        if (!this.isEnabled()) {
            return StreamNegotiationResult.IGNORE;
        }
        if (element instanceof StreamManagement) {
            StreamManager streamManager = this;
            synchronized (streamManager) {
                this.acknowledgedStanzaCount = 0L;
                this.enabledByClient = true;
            }
            this.unacknowledgedStanzas.clear();
            this.xmppSession.send((StreamElement)new StreamManagement.Enable(Boolean.valueOf(true)));
        } else {
            if (element instanceof StreamManagement.Enabled) {
                StreamManager streamManager = this;
                synchronized (streamManager) {
                    this.inboundCount = 0L;
                    this.enabled = (StreamManagement.Enabled)element;
                }
                return StreamNegotiationResult.SUCCESS;
            }
            if (element instanceof StreamManagement.Failed) {
                StreamManagement.Failed failed = (StreamManagement.Failed)element;
                if (failed.getLastHandledStanza() != null) {
                    this.markAcknowledged(failed.getLastHandledStanza());
                }
                this.resumed(false);
            } else if (element instanceof StreamManagement.Request) {
                StreamManagement.Answer answer;
                StreamManager streamManager = this;
                synchronized (streamManager) {
                    answer = new StreamManagement.Answer(this.inboundCount);
                }
                this.xmppSession.send((StreamElement)answer);
            } else if (element instanceof StreamManagement.Answer) {
                StreamManagement.Answer answer = (StreamManagement.Answer)element;
                this.markAcknowledged(answer.getLastHandledStanza());
            } else if (element instanceof StreamManagement.Resumed) {
                StreamManagement.Resumed resumed = (StreamManagement.Resumed)element;
                this.markAcknowledged(resumed.getLastHandledStanza());
                this.resumed(true);
                return StreamNegotiationResult.SUCCESS;
            }
        }
        return StreamNegotiationResult.INCOMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumed(boolean resumed) {
        CompletableFuture<Boolean> completableFuture;
        StreamManager streamManager = this;
        synchronized (streamManager) {
            completableFuture = this.resumeFuture;
        }
        if (completableFuture != null) {
            completableFuture.complete(resumed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAcknowledged(Long h) {
        if (h != null) {
            long x;
            StreamManager streamManager = this;
            synchronized (streamManager) {
                x = StreamManager.diff(h, this.acknowledgedStanzaCount);
                this.acknowledgedStanzaCount = h;
            }
            for (long i = 0L; i < x; ++i) {
                this.xmppSession.markAcknowledged(this.unacknowledgedStanzas.poll());
            }
        }
    }

    public final boolean canProcess(Object element) {
        return element instanceof StreamManagement.Request || element instanceof StreamManagement.Answer || element instanceof StreamManagement.Enabled || element instanceof StreamManagement.Failed || element instanceof StreamManagement.Resumed;
    }

    public final synchronized void incrementInboundStanzaCount() {
        this.inboundCount = this.inboundCount + 1L & 0xFFFFFFFFL;
    }

    public synchronized void markUnacknowledged(Stanza stanza) {
        if (this.enabledByClient) {
            this.unacknowledgedStanzas.offer(stanza);
        }
    }

    public final synchronized Predicate<Stanza> getRequestStrategy() {
        return this.requestStrategy;
    }

    public final synchronized void setRequestStrategy(Predicate<Stanza> requestStrategy) {
        this.requestStrategy = requestStrategy;
    }

    public final synchronized boolean isActive() {
        return this.enabled != null;
    }

    public final synchronized boolean isResumable() {
        return this.enabled != null && this.enabled.isResume();
    }

    public final synchronized String getStreamManagementId() {
        return this.enabled != null ? this.enabled.getId() : null;
    }

    public synchronized void reset() {
        this.enabled = null;
        this.enabledByClient = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult<Boolean> resume() {
        StreamManagement.Resume resume;
        if (!this.isResumable()) {
            return new AsyncResult(CompletableFuture.completedFuture(false));
        }
        CompletableFuture future = new CompletableFuture();
        StreamManager streamManager = this;
        synchronized (streamManager) {
            this.resumeFuture = future;
            resume = new StreamManagement.Resume(this.inboundCount, this.getStreamManagementId());
        }
        this.xmppSession.send((StreamElement)resume);
        return new AsyncResult(future);
    }
}

