/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.net.client.SocketConnector;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;

public final class TcpConnectionConfiguration
extends ClientConnectionConfiguration {
    private final Duration keepAliveInterval;
    private final TransportConnector<TcpConnectionConfiguration> connector;

    private TcpConnectionConfiguration(Builder builder) {
        super(builder);
        this.keepAliveInterval = builder.keepAliveInterval;
        this.connector = builder.getConnector();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Override
    public CompletableFuture<Connection> createConnection(XmppSession xmppSession, SessionOpen sessionOpen) {
        if (this.connector == null) {
            return new SocketConnector().connect(xmppSession, this, sessionOpen);
        }
        return this.connector.connect(xmppSession, this, sessionOpen);
    }

    public static class Builder
    extends ClientConnectionConfiguration.Builder<Builder, TcpConnectionConfiguration> {
        private Duration keepAliveInterval;

        protected Builder() {
            this.channelEncryption(ChannelEncryption.OPTIONAL);
            this.port(5222);
            this.keepAliveInterval(Duration.ofSeconds(30L));
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TcpConnectionConfiguration build() {
            return new TcpConnectionConfiguration(this);
        }

        public final Builder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }
    }
}

