/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.time.Instant;
import java.util.EventObject;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionEvent;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.ReconnectionStrategy;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

final class ReconnectionManager
extends Manager {
    private static final System.Logger logger = System.getLogger(ReconnectionManager.class.getName());
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"Reconnection Thread"));
    private final ScheduledExecutorService scheduledExecutorService;
    private final ReconnectionStrategy reconnectionStrategy;
    private ScheduledFuture<?> scheduledReconnectingInterval;
    private Instant nextReconnectionAttempt;

    private ReconnectionManager(XmppSession xmppSession) {
        super(xmppSession, false);
        ReconnectionStrategy configuredStrategy = xmppSession.getConfiguration().getReconnectionStrategy();
        this.reconnectionStrategy = configuredStrategy != null ? configuredStrategy : ReconnectionStrategy.onSystemShutdownFirstOrElseSecond(ReconnectionStrategy.truncatedBinaryExponentialBackoffStrategy(60, 4), ReconnectionStrategy.truncatedBinaryExponentialBackoffStrategy(10, 5));
        this.scheduledExecutorService = new QueuedScheduledExecutorService((Executor)EXECUTOR_SERVICE);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case DISCONNECTED: {
                    if (e.getOldStatus() != XmppSession.Status.AUTHENTICATED) break;
                    XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.DISCONNECTED, e.getThrowable(), Duration.ZERO));
                    if (!this.reconnectionStrategy.mayReconnect(0, e.getThrowable())) break;
                    this.scheduleReconnection(0, e.getThrowable());
                    break;
                }
                case CONNECTED: {
                    this.cancel();
                    break;
                }
                case CLOSED: {
                    this.cancel();
                    this.scheduledExecutorService.shutdown();
                    break;
                }
            }
        });
    }

    private synchronized void cancel() {
        this.nextReconnectionAttempt = null;
        if (this.scheduledReconnectingInterval != null) {
            this.scheduledReconnectingInterval.cancel(false);
        }
    }

    private synchronized void scheduleReconnection(int attempt, Throwable throwable) {
        if (this.isEnabled()) {
            Duration duration = this.reconnectionStrategy.getNextReconnectionAttempt(attempt, throwable);
            if (attempt == 0) {
                logger.log(System.Logger.Level.DEBUG, "Disconnect detected. Next reconnection attempt in {0} seconds.", duration.getSeconds());
            } else {
                logger.log(System.Logger.Level.DEBUG, "Still disconnected after {0} retries. Next reconnection attempt in {1} seconds.", attempt, duration.getSeconds());
            }
            this.nextReconnectionAttempt = Instant.now().plus(duration);
            this.scheduledReconnectingInterval = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Duration remainingDuration;
                ReconnectionManager reconnectionManager = this;
                synchronized (reconnectionManager) {
                    remainingDuration = Duration.between(Instant.now(), this.nextReconnectionAttempt);
                }
                if (!remainingDuration.isNegative()) {
                    XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.RECONNECTION_PENDING, throwable, remainingDuration));
                } else {
                    reconnectionManager = this;
                    synchronized (reconnectionManager) {
                        this.scheduledReconnectingInterval.cancel(false);
                    }
                    try {
                        this.xmppSession.connect();
                        logger.log(System.Logger.Level.DEBUG, "Reconnection successful.");
                    }
                    catch (XmppException e) {
                        logger.log(System.Logger.Level.DEBUG, "Reconnection failed.", (Throwable)e);
                        XmppUtils.notifyEventListeners(this.xmppSession.connectionListeners, (EventObject)new ConnectionEvent(this.xmppSession, ConnectionEvent.Type.RECONNECTION_FAILED, e, Duration.ZERO));
                        this.scheduleReconnection(attempt + 1, e);
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    protected final void onDisable() {
        super.onDisable();
        this.cancel();
    }

    static final class SystemShutdownPredicate
    implements BiPredicate<Integer, Throwable> {
        private boolean systemShutdown;

        SystemShutdownPredicate() {
        }

        @Override
        public final boolean test(Integer attempt, Throwable cause) {
            if (!this.systemShutdown || attempt == 0) {
                this.systemShutdown = cause instanceof StreamErrorException && ((StreamErrorException)cause).getCondition() == Condition.SYSTEM_SHUTDOWN;
            }
            return this.systemShutdown;
        }
    }
}

