/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import rocks.xmpp.core.session.HybridReconnectionStrategy;
import rocks.xmpp.core.session.ReconnectionManager;
import rocks.xmpp.core.session.TruncatedBinaryExponentialBackoffStrategy;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;

@FunctionalInterface
public interface ReconnectionStrategy {
    default public boolean mayReconnect(int attempt, Throwable e) {
        return !(e instanceof StreamErrorException) || ((StreamErrorException)e).getCondition() != Condition.CONFLICT;
    }

    public Duration getNextReconnectionAttempt(int var1, Throwable var2);

    public static ReconnectionStrategy truncatedBinaryExponentialBackoffStrategy(int slotTime, int ceiling) {
        return new TruncatedBinaryExponentialBackoffStrategy(slotTime, ceiling);
    }

    public static ReconnectionStrategy alwaysAfter(Duration duration) {
        return (attempt, cause) -> duration;
    }

    public static ReconnectionStrategy alwaysRandomlyAfter(Duration min, Duration max) {
        return (attempt, cause) -> Duration.ofSeconds(ThreadLocalRandom.current().nextLong(min.getSeconds(), max.getSeconds()));
    }

    public static ReconnectionStrategy onSystemShutdownFirstOrElseSecond(ReconnectionStrategy first, ReconnectionStrategy second) {
        return new HybridReconnectionStrategy(first, second, new ReconnectionManager.SystemShutdownPredicate());
    }

    public static ReconnectionStrategy none() {
        return new ReconnectionStrategy(){

            @Override
            public boolean mayReconnect(int attempt, Throwable cause) {
                return false;
            }

            @Override
            public Duration getNextReconnectionAttempt(int attempt, Throwable cause) {
                return Duration.ZERO;
            }
        };
    }
}

